% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_recent_extracts_info}
\alias{get_recent_extracts_info}
\alias{get_recent_extracts_info_list}
\alias{get_recent_extracts_info_tbl}
\title{Get information on recent extracts}
\usage{
get_recent_extracts_info_list(
  collection,
  how_many = 10,
  api_key = Sys.getenv("IPUMS_API_KEY")
)

get_recent_extracts_info_tbl(
  collection,
  how_many = 10,
  api_key = Sys.getenv("IPUMS_API_KEY")
)
}
\arguments{
\item{collection}{The code for an IPUMS data collection. For a list of the
codes used to refer to the data collections, see \code{\link[=ipums_data_collections]{ipums_data_collections()}}.}

\item{how_many}{Number of recent extracts for which you'd like information.
Defaults to 10 extracts.}

\item{api_key}{API key associated with your user account. Defaults to the
value of environment variable "IPUMS_API_KEY".}
}
\value{
For \code{get_recent_extracts_info_list()}, a list of extract objects. For
\code{get_recent_extracts_info_tbl()}, a \code{\link[tibble:tbl_df-class]{tibble}} with
information on one extract in each row.
}
\description{
Get information on recent extracts for a given IPUMS collection
via the IPUMS API, returned either as a list or tibble. For an overview of
ipumsr microdata API functionality, see
\code{vignette("ipums-api", package = "ipumsr")}.
}
\examples{
\dontrun{
# Get list of recent extracts
list_of_last_10_extracts <- get_recent_extracts_info_list("usa")

# Print the extract number for extracts that are downloadable:
for (extract in list_of_last_10_extracts) {
  if (is_extract_ready(extract)) print(extract$number)
}

# Get tibble of recent extracts
tbl_of_last_10_extracts <- get_recent_extracts_info_tbl("usa")

# Filter down to extracts with "income" in the description
description_mentions_income <- grepl(
  "[Ii]ncome",
  tbl_of_last_10_extracts$description
)
income_extracts <- tbl_of_last_10_extracts[description_mentions_income, ]

# Convert tibble of extracts to list of extracts
income_extracts <- extract_tbl_to_list(income_extracts)

# Now it's easier to operate on those elements as extract objects:
revised_income_extract <- add_to_extract(
  income_extracts[[1]],
  samples = "us2018a"
)

submitted_revised_income_extract <- submit_extract(revised_income_extract)
}

}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{ipums_data_collections}()},
\code{\link{is_extract_ready}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
