% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-terra_read.R
\name{read_terra_raster}
\alias{read_terra_raster}
\alias{read_terra_raster_list}
\title{Read data from an IPUMS Terra raster extract}
\usage{
read_terra_raster(data_file, data_layer = NULL, verbose = TRUE)

read_terra_raster_list(data_file, data_layer = NULL, verbose = TRUE)
}
\arguments{
\item{data_file}{Filepath to the data (either the .zip file directly downloaded
from the website, or the path to the unzipped .tiff file(s)).}

\item{data_layer}{For .zip extracts with multiple raster datasets, the name of the
data to load. Accepts a character vector specifying the file name, or
a \link[=selection_language]{tidyselect selection}.}

\item{verbose}{Logical, indicating whether to print progress information
to console.}
}
\value{
For \code{read_terra_raster} A \code{\link[raster]{raster}} object, for
\code{read_terra_raster_list} A list of raster objects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Read a single raster datasets downloaded from the IPUMS Terra extract system using
\code{read_terra_raster}, or read multiple into a list using \code{read_terra_raster_list}.

Support for IPUMS Terra has been discontinued. These functions will be
removed in a future release. For general handling of raster data in R, see
the \href{https://github.com/rspatial/terra}{terra} package.

\emph{Note: Reading IPUMS Terra raster extracts requires installation of the
raster package, which is no longer installed automatically when you install
ipumsr.}
}
\examples{
\dontrun{
data <- read_terra_raster("2552_bundle.zip", "LCDECIDOPZM2013.tiff")
data <- read_terra_raster_list("2552_bundle.zip", "ZM")
}
}
\keyword{internal}
