% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{add_to_extract}
\alias{add_to_extract}
\title{Add values to an existing IPUMS extract definition}
\usage{
add_to_extract(extract, ...)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{...}{Additional arguments specifying the extract fields and values to
add to the extract definition.

All arguments available in \code{\link[=define_extract_micro]{define_extract_micro()}} (for microdata
extract requests) or \code{\link[=define_extract_nhgis]{define_extract_nhgis()}} (for NHGIS extract requests)
can be passed to \code{add_to_extract()}.}
}
\value{
An object of the same class as \code{extract} containing the modified
extract definition
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Add or replace values in an existing \code{ipums_extract} object.
This function is an S3 generic whose behavior will depend on the
subclass (i.e. collection) of the extract being modified.
\itemize{
\item To add to an \strong{IPUMS Microdata} extract definition, click
\link[=add_to_extract.micro_extract]{here}. This includes:
\itemize{
\item IPUMS USA
\item IPUMS CPS
\item IPUMS International
\item IPUMS Time Use (ATUS, AHTUS, MTUS)
\item IPUMS Health Surveys (NHIS, MEPS)
}
\item To add to an \strong{IPUMS NHGIS} extract definition, click
\link[=add_to_extract.nhgis_extract]{here}
}

This function is marked as experimental because it is typically not the best
option for maintaining reproducible extract definitions and may be retired
in the future. For reproducibility, users should strive to build extract
definitions with \code{\link[=define_extract_micro]{define_extract_micro()}} or \code{\link[=define_extract_nhgis]{define_extract_nhgis()}}.

If you have a complicated extract definition to revise, but do not have
the original extract definition code that created it, we suggest that you
save the revised extract as a JSON file with \code{\link[=save_extract_as_json]{save_extract_as_json()}}. This
will create a stable version of the extract definition that
can be used in the future as needed.

To remove existing values from an extract definition, use
\code{\link[=remove_from_extract]{remove_from_extract()}}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\examples{
# Microdata extracts
usa_extract <- define_extract_micro(
  collection = "usa",
  description = "2013 ACS Data",
  samples = "us2013a",
  variables = c("SEX", "AGE", "YEAR")
)

# Add new samples and variables
add_to_extract(
  usa_extract,
  samples = c("us2014a", "us2015a"),
  variables = var_spec("MARST", data_quality_flags = TRUE)
)

# Update existing variables
add_to_extract(
  usa_extract,
  variables = var_spec("SEX", case_selections = "1")
)

# Modify/add multiple variables
add_to_extract(
  usa_extract,
  variables = list(
    var_spec("SEX", case_selections = "1"),
    var_spec("RELATE")
  )
)

# NHGIS extracts
nhgis_extract <- define_extract_nhgis(
  datasets = ds_spec(
    "1990_STF1",
    data_tables = c("NP1", "NP2"),
    geog_levels = "county"
  )
)

# Add a new dataset or time series table
add_to_extract(
  nhgis_extract,
  datasets = ds_spec(
    "1980_STF1",
    data_tables = "NT1A",
    geog_levels = c("county", "state")
  )
)

# Update existing datasets/time series tables
add_to_extract(
  nhgis_extract,
  datasets = ds_spec("1990_STF1", c("NP1", "NP2"), "state")
)

# Modify/add multiple datasets or time series tables
add_to_extract(
  nhgis_extract,
  time_series_tables = list(
    tst_spec("CW3", geog_levels = "state"),
    tst_spec("CW4", geog_levels = "state")
  )
)

# Values that can only take a single value are replaced
add_to_extract(nhgis_extract, data_format = "fixed_width")$data_format
}
\seealso{
\code{\link[=remove_from_extract]{remove_from_extract()}} to remove values from an extract definition.

\code{\link[=define_extract_micro]{define_extract_micro()}} or \code{\link[=define_extract_nhgis]{define_extract_nhgis()}} to define an
extract request manually.

\code{\link[=submit_extract]{submit_extract()}} to submit an extract request for processing.
}
\keyword{internal}
