% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.R
\name{zap_ipums_attributes}
\alias{zap_ipums_attributes}
\title{Remove label attributes from a data frame or labelled vector}
\usage{
zap_ipums_attributes(x)
}
\arguments{
\item{x}{A data frame or \link[haven:labelled]{labelled} vector
(for instance, from a data frame column)}
}
\value{
An object of the same type as \code{x} without \code{"val_labels"},
\verb{"var_label}", and \code{"var_desc"} attributes.
}
\description{
Remove all label attributes (value labels, variable labels, and variable
descriptions) from a data frame or vector.
}
\examples{
cps <- read_ipums_micro(ipums_example("cps_00157.xml"))

attributes(cps$YEAR)
attributes(zap_ipums_attributes(cps$YEAR))

cps <- zap_ipums_attributes(cps)
attributes(cps$YEAR)
attributes(cps$INCTOT)
}
\seealso{
Other lbl_helpers: 
\code{\link{lbl}()},
\code{\link{lbl_add}()},
\code{\link{lbl_clean}()},
\code{\link{lbl_define}()},
\code{\link{lbl_na_if}()},
\code{\link{lbl_relabel}()}
}
\concept{lbl_helpers}
