% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_extract_info.R
\name{get_extract_info}
\alias{get_extract_info}
\alias{get_last_extract_info}
\title{Retrieve the definition and latest status of an extract request}
\usage{
get_extract_info(extract, api_key = Sys.getenv("IPUMS_API_KEY"))

get_last_extract_info(collection = NULL, api_key = Sys.getenv("IPUMS_API_KEY"))
}
\arguments{
\item{extract}{One of:
\itemize{
\item An \code{\link[=ipums_extract-class]{ipums_extract}} object
\item The data collection and extract number formatted as a string of the
form \code{"collection:number"} or as a vector of the form
\code{c("collection", number)}
\item An extract number to be associated with your default IPUMS
collection. See \code{\link[=set_ipums_default_collection]{set_ipums_default_collection()}}
}

For a list of codes used to refer to each collection, see
\code{\link[=ipums_data_collections]{ipums_data_collections()}}.}

\item{api_key}{API key associated with your user account. Defaults to the
value of the \code{IPUMS_API_KEY} environment variable. See
\code{\link[=set_ipums_api_key]{set_ipums_api_key()}}.}

\item{collection}{Character string of the IPUMS collection for which to
retrieve extract history. Defaults to the current default
collection, if it exists. See \code{\link[=set_ipums_default_collection]{set_ipums_default_collection()}}.

For a list of codes used to refer to each collection, see
\code{\link[=ipums_data_collections]{ipums_data_collections()}}.}
}
\value{
An \code{\link[=ipums_extract-class]{ipums_extract}} object.
}
\description{
Retrieve the latest status of an extract request.

\code{get_last_extract_info()} is a convenience function to retrieve the most
recent extract for a given collection.

To browse definitions of your previously submitted extract requests, see
\code{\link[=get_extract_history]{get_extract_history()}}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\examples{
my_extract <- define_extract_micro(
  collection = "usa",
  description = "2013-2014 ACS Data",
  samples = c("us2013a", "us2014a"),
  variables = c("SEX", "AGE", "YEAR")
)

\dontrun{
submitted_extract <- submit_extract(my_extract)

# Get latest info for the request associated with a given `ipums_extract`
# object:
updated_extract <- get_extract_info(submitted_extract)

updated_extract$status

# Or specify the extract collection and number:
get_extract_info("usa:1")
get_extract_info(c("usa", 1))

# If you have a default collection, you can use the extract number alone:
set_ipums_default_collection("nhgis")
get_extract_info(1)

# To get the most recent extract (for instance, if you have forgotten its
# extract number), use `get_last_extract_info()`
get_last_extract_info("nhgis")
}
}
\seealso{
\code{\link[=get_extract_history]{get_extract_history()}} to browse past extract definitions

\code{\link[=wait_for_extract]{wait_for_extract()}} to wait for an extract to finish processing.

\code{\link[=download_extract]{download_extract()}} to download an extract's data files.

\code{\link[=save_extract_as_json]{save_extract_as_json()}} and \code{\link[=define_extract_from_json]{define_extract_from_json()}} to share an
extract definition.
}
