% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{info}
\alias{info}
\alias{info,Item-method}
\alias{info,Itempool-method}
\alias{info,Testlet-method}
\alias{info,numMatDfListChar-method}
\title{Calculates the information of an "Item" object}
\usage{
info(ip, theta, tif = FALSE, observed = FALSE, resp = NULL)

\S4method{info}{Item}(ip, theta, tif = FALSE, observed = FALSE, resp = NULL)

\S4method{info}{Itempool}(ip, theta, tif = FALSE, observed = FALSE, resp = NULL)

\S4method{info}{Testlet}(ip, theta, tif = FALSE, observed = FALSE, resp = NULL)

\S4method{info}{numMatDfListChar}(ip, theta, tif = FALSE, observed = FALSE, resp = NULL)
}
\arguments{
\item{ip}{An \code{\link{Item-class}}, \code{\link{Itempool-class}} or
\code{\link{Testlet-class}} object.}

\item{theta}{An vector of ability parameters.}

\item{tif}{If it is \code{TRUE}, function will return total
information obtained from each item for a given theta. It simply adds
information of individual items.}

\item{observed}{If \code{TRUE}, observed information calculated instead of
the default expected information.}

\item{resp}{A response string (vector or a matrix). Necessary for observed
information.}
}
\value{
A vector (or matrix) consist of item or test information.
}
\description{
This function sets a generic method for calculating the information of
a suitable object
}
\examples{
info(ip = generate_item(model = "Rasch"), theta = rnorm(1))
info(ip = generate_item(model = "1PL"), theta = rnorm(1))
info(ip = generate_item(model = "2PL"), theta = rnorm(1))
info(ip = generate_item(model = "3PL"), theta = rnorm(1))
info(ip = generate_item(model = "4PL"), theta = rnorm(1))
info(ip = generate_item(model = "GRM"), theta = rnorm(1))
info(ip = generate_item(model = "GPCM"), theta = rnorm(1))
info(ip = generate_item(model = "PCM"), theta = rnorm(1))
info(ip = generate_item(model = "GPCM2"), theta = rnorm(1))

info(ip = generate_ip(model = "Rasch"), theta = rnorm(1))
info(ip = generate_ip(model = "1PL"), theta = rnorm(1))
info(ip = generate_ip(model = "2PL"), theta = rnorm(1))
info(ip = generate_ip(model = "3PL"), theta = rnorm(1))
info(ip = generate_ip(model = "4PL"), theta = rnorm(1))
info(ip = generate_ip(model = "GRM"), theta = rnorm(1))
info(ip = generate_ip(model = "GPCM"), theta = rnorm(1))
info(ip = generate_ip(model = "PCM"), theta = rnorm(1))
info(ip = generate_ip(model = "GPCM2"), theta = rnorm(1))

# Multiple Thetas
info(ip = generate_ip(model = "3PL"), theta = rnorm(5))
info(ip = generate_ip(model = "GRM"), theta = rnorm(7))

# Test information function value at theta
info(ip = generate_ip(model = "3PL"), theta = rnorm(5), tif = TRUE)
info(ip = generate_ip(model = "GRM"), theta = rnorm(7), tif = TRUE)

# Information values of an item pool with multiple models
ip <- generate_ip(model = c("2PL", "3PL", "GPCM", "3PL", "GPCM"))
theta <- rnorm(sample(6:10, 1))
info(ip = ip, theta = theta[1])
info(ip = ip, theta = theta)
info(ip = ip, theta = theta, tif = TRUE)

t1 <- generate_testlet(item_models = c("2PL", "3PL", "GRM", "3PL", "GRM"))
theta <- rnorm(sample(6:10, 1))
info(ip = t1, theta = theta[1])
info(ip = t1, theta = theta)
info(ip = t1, theta = theta, tif = TRUE)
}
\author{
Emre Gonulates
}
