% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Item-class-methods.R
\name{$,Item-method}
\alias{$,Item-method}
\title{Get slots from an \code{\link{Item-class}} object.}
\usage{
\S4method{$}{Item}(x, name)
}
\arguments{
\item{x}{An \code{\link{Item-class}} object.}

\item{name}{Name of the parameter.

  Available values:
  \describe{
    \item{\strong{\code{'id'}}}{Extract \code{'id'} of an
      \code{\link{Item-class}} object.}
    \item{\strong{\code{'model'}}}{Extract the \code{'model'} of an
      \code{\link{Item-class}} object.}
    \item{\strong{\code{'parameters'}}}{Extract the \code{'parameters'} of an
      \code{\link{Item-class}} object.}
    \item{\strong{\code{'se_parameters'}}}{Extract the standard error of
      parameters of an \code{\link{Item-class}} object.}
    \item{\strong{\code{'content'}}}{Extract the \code{'content'} slot of an
      \code{\link{Item-class}} object.}
    \item{\strong{\code{'misc'}}}{Extract the \code{'misc'} slot of an
      \code{\link{Item-class}} object.}
    \item{\strong{\code{'max_score'}}}{Extract the maximum possible score
      of an \code{\link{Item-class}} object. Minimum score is assumed to be
      0.}
  }}
}
\value{
This operation will return the desired slot.
}
\description{
Get slots from an \code{\link{Item-class}} object.
}
\examples{
item1 <- item(model =  "3PL", id = 'item23', content = 'Geometry',
              misc = list(enemies = c("item1", "item2")),
              parameters = list(b = 2, c = .12, a = 1.2, D = 1))
# Get individual parameters
item1$a
item1$b
item1$D
# Get item 'model'
item1$model
# Get all parameters
item1$parameters
# Get item 'id'
item1$id
# Get item content
item1$content
# Get misc values
item1$misc
# Get misc values
item1$max_score
}
\author{
Emre Gonulates
}
