% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracelines.R
\name{trf}
\alias{trf}
\title{Test response function}
\usage{
trf(ip, x = NULL)
}
\arguments{
\item{ip}{Item parameters: the output of \code{est}, or a 3-column matrix 
corresponding to its first element, \code{est}.}

\item{x}{The values of the latent variable (\eqn{\theta} in the equation
above), at which the IRF will be evaluated. If not given, 99 values spaced
evenly between -4 and +4 will be used, handy for plotting.}
}
\value{
A list of: \item{x}{A copy of the argument \code{x}} \item{f}{A
vector containing the TRF values}
}
\description{
Returns the test response function (TRF) of the 3PL (1PL, 2PL) model. The
TRF is the sum of the item response functions (IRF) in a test, and
represents the expected score as a function of the latent variable
\eqn{\theta}.
}
\details{
A common use of this function would be to obtain a plot of the TRF.
}
\examples{

plot(trf(Scored2pl))

}
\seealso{
\code{\link{plot.trf}}, \code{\link{irf}}
}
\author{
Ivailo Partchev
}
\keyword{models}
