#' @title piru13C
#'
#' @description Accompanying tree ring carbon isotope signature data for "Mathias, J.M. & Thomas, R.B. Disentangling the effects of acidic air pollution, atmospheric CO2, and climate change
#' on recent growth of red spruce trees in the Central Appalachian Mountains. Glob. Chang. Biol. 24, 3938–3953 (2018).".
#'
#' @docType data
#'
#' @usage data(piru13C)
#'
#' @format A data frame with 223 rows and 6 variables:
#' \describe{
#'   \item{Year}{Year of sample}
#'   \item{Site}{Study location name}
#'   \item{wood.d13C}{Measured tree ring (i.e. wood) d13C, in per mille, ‰}
#'   \item{MGT_C}{Mean growing season temperature, °C}
#'   \item{Elevation_m}{Elevation of study location, meters}
#'   \item{frac}{Leaf-to-wood fractionation factor}
#' }
#'
#' @keywords datasets
#'
#' @references Mathias, J.M. & Thomas, R.B. Disentangling the effects of acidic air pollution, atmospheric CO2, and climate change
#' on recent growth of red spruce trees in the Central Appalachian Mountains. Glob. Chang. Biol. 24, 3938–3953 (2018).
#'
#' @source https://onlinelibrary.wiley.com/doi/full/10.1111/gcb.14273
#'
#' @examples
#'
#'
#' data(piru13C)
#' head(piru13C)
"piru13C"


