% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotopeAssignmentModel.R
\name{isotopeAssignmentModel}
\alias{isotopeAssignmentModel}
\title{Isotope assignment model function}
\usage{
isotopeAssignmentModel(
  ID,
  isotopeValue,
  SD_indv,
  precip_raster,
  precip_SD_raster,
  additionalModel = FALSE,
  additionalModel_name = "CombinedIsotope-OtherModelAssignments",
  savePath = FALSE,
  nClusters = FALSE
)
}
\arguments{
\item{ID}{ID value or vector of values (for naming assignment model layers). If missing, will count from 1.}

\item{isotopeValue}{Isotope precipitation value or vector of values.}

\item{SD_indv}{error associated with transfer function fit. Value or vector of values. If missing, will assume value of 0.}

\item{precip_raster}{precipitation isoscape raster.}

\item{precip_SD_raster}{precipitation isoscape standard deviation raster.}

\item{additionalModel}{optional additional model RasterLayer (e.g. an SDM, rasterized range map). If specified, function will return isotope assignment rasters and the product of this additionalModel and each assignmentRaster.}

\item{additionalModel_name}{optional filename for additionalModel .grd path}

\item{savePath}{If specified, function will save results to this path as a '.grd' file.}

\item{nClusters}{integer of cores to run in parallel with doParallel. Default FALSE.}
}
\description{
Creates isotope assignment models projections of probable origin. Results returned as a RasterStack, with layer names corresponding to individual ID.
}
\examples{
myiso <- rasterFromXYZ(isoscape)
raster::plot(myiso)
myiso_sd <- rasterFromXYZ(isoscape_sd)
df <- data.frame(
         ID = c(-100, -80, -50),
         isotopeValue = c(-100, -80, -50),
         SD_indv = rep(5, 3)
         )
assignmentModels <- isotopeAssignmentModel(
                        ID = df$ID,
                        isotopeValue = df$isotopeValue,
                        SD_indv = df$SD_indv,
                        precip_raster = myiso,
                        precip_SD_raster = myiso_sd,
                        nClusters = FALSE
                        )
raster::plot(assignmentModels)

}
