% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_crosshairs.R
\docType{methods}
\name{ternary_crosshairs}
\alias{ternary_crosshairs}
\alias{ternary_crosshairs-method}
\alias{ternary_crosshairs,numeric,numeric,numeric-method}
\alias{ternary_crosshairs,ANY,missing,missing-method}
\title{Add Cross-Hairs to a Ternary Plot}
\usage{
ternary_crosshairs(x, y, z, ...)

\S4method{ternary_crosshairs}{numeric,numeric,numeric}(x, y, z, x_mark = TRUE, y_mark = TRUE, z_mark = TRUE, ...)

\S4method{ternary_crosshairs}{ANY,missing,missing}(x, x_mark = TRUE, y_mark = TRUE, z_mark = TRUE, ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further graphical parameters (see \code{\link[graphics:par]{graphics::par()}}) may also be
supplied as arguments, particularly, line type, \code{lty}, line width, \code{lwd} and
color, \code{col}. Also the line characteristics \code{lend}, \code{ljoin} and \code{lmitre}.}

\item{x_mark, y_mark, z_mark}{A \code{\link{logical}} scalar: should the \code{x}, \code{y} or \code{z}
axis component be drawn?}
}
\value{
\code{ternary_crosshairs()} is called it for its side-effects.
}
\description{
Draw lines that intersect at a point.
}
\examples{
## Add cross-hairs
## Data from Aitchison 1986
ternary_plot(lava, panel.first = ternary_grid())
ternary_crosshairs(lava)

ternary_plot(lava, panel.first = ternary_grid())
ternary_crosshairs(lava, y_mark = FALSE, z_mark = FALSE, col = "red")

ternary_plot(lava, panel.first = ternary_grid())
ternary_crosshairs(lava, x_mark = FALSE, z_mark = FALSE, col = "green")

ternary_plot(lava, panel.first = ternary_grid())
ternary_crosshairs(lava, x_mark = FALSE, y_mark = FALSE, col = "blue")
}
\seealso{
Other geometries: 
\code{\link{ternary_arrows}()},
\code{\link{ternary_lines}()},
\code{\link{ternary_points}()},
\code{\link{ternary_polygon}()},
\code{\link{ternary_segments}()},
\code{\link{ternary_text}()}
}
\author{
N. Frerebeau
}
\concept{geometries}
