% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{iso_root_paths}
\alias{iso_root_paths}
\title{Root paths}
\usage{
iso_root_paths(path, root = ".", check_existence = TRUE)
}
\arguments{
\item{path}{vector of file/folder paths, mixed relative and absolute paths are allowed.}

\item{root}{root directory for the isofiles. Can be relative to the current working directory (e.g. \code{"data"}) or an absolute path on the file system (e.g. \code{"/Users/..."} or \code{"C:/Data/.."}). The default is the current working directory (\code{"."}). Can be supplied as a vector of same length as the provided paths if the paths have different roots.}

\item{check_existence}{whether to check for the existence of the paths}
}
\value{
a data frame with the root directories and paths relative to the root - order of input paths is preserved
}
\description{
Function to root both relative and absolute paths to a root directory (or directories) commonly relative to current working directory. Determines the best way to shorten relative paths and put absolute paths in a relative context (if possible) using \link{iso_shorten_relative_paths} and \link{iso_find_absolute_path_roots}, respectively.
}
\seealso{
Other file system functions: 
\code{\link{iso_expand_paths}()},
\code{\link{iso_find_absolute_path_roots}()},
\code{\link{iso_shorten_relative_paths}()}
}
\concept{file system functions}
