% Generated by roxygen2 (4.0.1): do not edit by hand
\name{irep}
\alias{irep}
\alias{irep_len}
\title{Iterator that replicates elements of an iterable object}
\usage{
irep(object, times = 1, length.out = NULL, each = NULL)

irep_len(object, length.out = NULL)
}
\arguments{
\item{object}{object to return indefinitely.}

\item{times}{the number of times to repeat each element in \code{object}}

\item{length.out}{non-negative integer. The desired length of the iterator}

\item{each}{non-negative integer. Each element is repeated \code{each} times}
}
\value{
iterator that returns \code{object}
}
\description{
Constructs an iterator that replicates the values of an \code{object}.
}
\details{
This function is intended an iterable version of the standard
\code{\link[base]{rep}} function. However, as exception, the recycling
behavior of \code{\link[base]{rep}} is intentionally not implemented.
}
\examples{
it <- irep(1:3, 2)
unlist(as.list(it)) == rep(1:3, 2)

it2 <- irep(1:3, each=2)
unlist(as.list(it2)) == rep(1:3, each=2)

it3 <- irep(1:3, each=2, length.out=4)
as.list(it3)
}

