% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot_diff.R
\name{plot_diff}
\alias{plotDiff}
\alias{plot_diff}
\title{Plot difference curve based on model predictions.}
\usage{
plot_diff(model, view, comp, eegAxis = F, f = 1.96, ylim = NULL,
  ylab = NULL, main = NULL, plot = TRUE, ...)
}
\arguments{
\item{model}{A GAMM model, resulting from the functions
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{view}{Name of continuous predictor that should be plotted on the x-
axis.}

\item{comp}{Named list with the grouping predictor (categorical variable)
and the 2 levels to calculate the difference for.}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting
negative values upwards. Default is FALSE.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting
in 95\% confidence intervals. For 99\% confidence intervals use a value of
2.58.}

\item{ylim}{Range of y-axis. If not specified, the function automatically
generates an appropriate y-axis.}

\item{ylab}{Text string, alternative label for y-axis.}

\item{main}{Text string, alternative title for plot.}

\item{plot}{Logical: whether or not to plot the difference. If FALSE, then
the output is returned as a list, with the estimated difference
(\code{est}) and the standard error over the estimate (\code{se.est}) and
the x-values (\code{x}). Default is TRUE.}

\item{...}{Optional arguments for plot.}
}
\value{
If the result is not being plotted, a list is
returned with the estimated difference (\code{est}) and the standard error
over the estimate (\code{se.est}) and the x-values (\code{x}) is returned.
}
\description{
Plot difference curve based on model predictions.
}
\examples{
data(simdat)
\dontrun{
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group),
    data=simdat)
plot_diff(m1, view='Time', comp=list(Group=c("Children", "Adults")))
# Reversed y-axis (for EEG data):
plot_diff(m1, view='Time', comp=list(Group=c("Children", "Adults")),
    eegAxis=TRUE)
# retrieving plot values...
out <- plot_diff(m1, view='Time', comp=list(Group=c("Children", "Adults")),
   plot=FALSE)
#... which might be used for indicating differences:
x <- find_difference(out$est, out$se, f=1.96, xVals=out$xVals)
# add lines:
arrows(x0=x$start, x1=x$end, y0=0, y1=0,code=3, length=.1, col='red')
}
# see the vignette for examples:
vignette("plotfunctions", package="itsadug")
}
\author{
Martijn Wieling
}
\seealso{
Other functions for interpreting nonlinear effects: \code{\link{fvisgam}},
  \code{\link{vis.gam2}}; \code{\link{plotDiff2D}},
  \code{\link{plot_diff2}}; \code{\link{plot_parametric}};
  \code{\link{plot_smooth}}; \code{\link{pvis.gam}},
  \code{\link{pvisgam}}
}

