% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{observations}
\alias{observations}
\title{Number of observations in the model.}
\usage{
observations(model)
}
\arguments{
\item{model}{A fitted regression model (using gam, bam, (g)lm, (g)lmer).}
}
\value{
Numeric value: number of observations that are considered by the 
model.
}
\description{
Number of observations in the model.
}
\examples{
data(simdat)
# simulate some missing data:
simdat[sample(1:nrow(simdat), size=15),]$Y <- NA
simdat[sample(1:nrow(simdat), size=7),]$Group <- NA

# Fit simple GAM models:
gam1 <- bam(Y ~ s(Time), data=simdat, discrete=TRUE)
gam2 <- bam(Y ~ Group + s(Time, by=Group), data=simdat, discrete=TRUE)

# number of data points in data frame:
nrow(simdat)

# observations model gam1:
observations(gam1)
# observations model gam2:
observations(gam2)

}
\seealso{
Other Utility functions: 
\code{\link{convertNonAlphanumeric}()},
\code{\link{corfit}()},
\code{\link{diff_terms}()},
\code{\link{find_difference}()},
\code{\link{missing_est}()},
\code{\link{modeledf}()},
\code{\link{print_summary}()},
\code{\link{refLevels}()},
\code{\link{res_df}()},
\code{\link{summary_data}()},
\code{\link{timeBins}()}
}
\concept{Utility functions}
