% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{AmericanSoccerAnalysis}
\alias{AmericanSoccerAnalysis}
\title{American Soccer Analysis API Client}
\description{
Class representing an active session connected to the American Soccer Analysis public API.
}
\details{
Does not take any arguments to initialize.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{API_VERSION}}{Latest API version.}

\item{\code{MAX_API_LIMIT}}{Maximum number of requests returned by the API by default.}

\item{\code{LEAGUES}}{List of stylized league names.}

\item{\code{base_url}}{API base URL.}

\item{\code{players}}{Data frame containing players from all leagues.}

\item{\code{teams}}{Data frame containing teams from all leagues.}

\item{\code{stadia}}{Data frame containing stadia from all leagues.}

\item{\code{managers}}{Data frame containing managers from all leagues.}

\item{\code{referees}}{Data frame containing referees from all leagues.}

\item{\code{httr_configs}}{Configs to pass on to all \code{httr} functions. See \href{https://www.rdocumentation.org/packages/httr/versions/1.4.2/topics/config}{documentation}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AmericanSoccerAnalysis$new()}}
\item \href{#method-add_httr_configs}{\code{AmericanSoccerAnalysis$add_httr_configs()}}
\item \href{#method-reset_httr_configs}{\code{AmericanSoccerAnalysis$reset_httr_configs()}}
\item \href{#method-get_players}{\code{AmericanSoccerAnalysis$get_players()}}
\item \href{#method-get_teams}{\code{AmericanSoccerAnalysis$get_teams()}}
\item \href{#method-get_stadia}{\code{AmericanSoccerAnalysis$get_stadia()}}
\item \href{#method-get_managers}{\code{AmericanSoccerAnalysis$get_managers()}}
\item \href{#method-get_referees}{\code{AmericanSoccerAnalysis$get_referees()}}
\item \href{#method-get_games}{\code{AmericanSoccerAnalysis$get_games()}}
\item \href{#method-get_player_xgoals}{\code{AmericanSoccerAnalysis$get_player_xgoals()}}
\item \href{#method-get_player_xpass}{\code{AmericanSoccerAnalysis$get_player_xpass()}}
\item \href{#method-get_player_goals_added}{\code{AmericanSoccerAnalysis$get_player_goals_added()}}
\item \href{#method-get_goalkeeper_xgoals}{\code{AmericanSoccerAnalysis$get_goalkeeper_xgoals()}}
\item \href{#method-get_goalkeeper_goals_added}{\code{AmericanSoccerAnalysis$get_goalkeeper_goals_added()}}
\item \href{#method-get_team_xgoals}{\code{AmericanSoccerAnalysis$get_team_xgoals()}}
\item \href{#method-get_team_xpass}{\code{AmericanSoccerAnalysis$get_team_xpass()}}
\item \href{#method-get_team_goals_added}{\code{AmericanSoccerAnalysis$get_team_goals_added()}}
\item \href{#method-get_game_xgoals}{\code{AmericanSoccerAnalysis$get_game_xgoals()}}
\item \href{#method-clone}{\code{AmericanSoccerAnalysis$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{AmericanSoccerAnalysis} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Configs to pass on to all \code{httr} functions. See \href{https://www.rdocumentation.org/packages/httr/versions/1.4.2/topics/config}{documentation}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{AmericanSoccerAnalysis} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_httr_configs"></a>}}
\if{latex}{\out{\hypertarget{method-add_httr_configs}{}}}
\subsection{Method \code{add_httr_configs()}}{
Appends new \code{httr} configs to the existing class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$add_httr_configs(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Configs to pass on to all \code{httr} functions. See \href{https://www.rdocumentation.org/packages/httr/versions/1.4.2/topics/config}{documentation}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset_httr_configs"></a>}}
\if{latex}{\out{\hypertarget{method-reset_httr_configs}{}}}
\subsection{Method \code{reset_httr_configs()}}{
Removes all \code{httr} configs from the existing class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$reset_httr_configs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_players"></a>}}
\if{latex}{\out{\hypertarget{method-get_players}{}}}
\subsection{Method \code{get_players()}}{
Retrieves a data frame containing player names, IDs, and other metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_players(leagues, ids, names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{ids}}{Player IDs on which to filter. Cannot be combined with \code{names}. Accepts a character vector of length >= 1.}

\item{\code{names}}{Player names on which to filter. Partial matches are accepted. Cannot be combined with \code{ids}. Accepts a character vector of length >= 1.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_teams"></a>}}
\if{latex}{\out{\hypertarget{method-get_teams}{}}}
\subsection{Method \code{get_teams()}}{
Retrieves a data frame containing team names, abbreviations, and IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_teams(leagues, ids, names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{ids}}{Team IDs on which to filter. Cannot be combined with \code{names}. Accepts a character vector of length >= 1.}

\item{\code{names}}{Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{ids}. Accepts a character vector of length >= 1.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_stadia"></a>}}
\if{latex}{\out{\hypertarget{method-get_stadia}{}}}
\subsection{Method \code{get_stadia()}}{
Retrieves a data frame containing stadium names, IDs, and other metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_stadia(leagues, ids, names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{ids}}{Stadium IDs on which to filter. Cannot be combined with \code{names}. Accepts a character vector of length >= 1.}

\item{\code{names}}{Stadium names on which to filter. Partial matches are accepted. Cannot be combined with \code{ids}. Accepts a character vector of length >= 1.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_managers"></a>}}
\if{latex}{\out{\hypertarget{method-get_managers}{}}}
\subsection{Method \code{get_managers()}}{
Retrieves a data frame containing manager names and IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_managers(leagues, ids, names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{ids}}{Manager IDs on which to filter. Cannot be combined with \code{names}. Accepts a character vector of length >= 1.}

\item{\code{names}}{Manager names on which to filter. Partial matches are accepted. Cannot be combined with \code{ids}. Accepts a character vector of length >= 1.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_referees"></a>}}
\if{latex}{\out{\hypertarget{method-get_referees}{}}}
\subsection{Method \code{get_referees()}}{
Retrieves a data frame containing referee names and IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_referees(leagues, ids, names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{ids}}{Referee IDs on which to filter. Cannot be combined with \code{names}. Accepts a character vector of length >= 1.}

\item{\code{names}}{Referee names on which to filter. Partial matches are accepted. Cannot be combined with \code{ids}. Accepts a character vector of length >= 1.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_games"></a>}}
\if{latex}{\out{\hypertarget{method-get_games}{}}}
\subsection{Method \code{get_games()}}{
Retrieves a data frame containing game IDs, dates, opponents, scores, and other metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_games(
  leagues,
  game_ids,
  team_ids,
  team_names,
  seasons,
  stages
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{game_ids}}{Game IDs on which to filter. Accepts a character vector of length >= 1.}

\item{\code{team_ids}}{Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.}

\item{\code{team_names}}{Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.}

\item{\code{seasons}}{Name(s)/year(s) of seasons. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.}

\item{\code{stages}}{Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_player_xgoals"></a>}}
\if{latex}{\out{\hypertarget{method-get_player_xgoals}{}}}
\subsection{Method \code{get_player_xgoals()}}{
Retrieves a data frame containing player xG data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_player_xgoals(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{minimum_minutes}: Minimum threshold for sum of minutes played.
  \item \code{minimum_shots}: Minimum threshold for sum of shots taken.
  \item \code{minimum_key_passes}: Minimum threshold for sum of key passes.
  \item \code{player_ids}: Player IDs on which to filter. Cannot be combined with \code{player_names}. Accepts a character vector of length >= 1.
  \item \code{player_names}: Player names on which to filter. Partial matches are accepted. Cannot be combined with \code{player_ids}. Accepts a character vector of length >= 1.
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{shot_pattern}: Describes the possessing actions leading to the shot. Valid keywords include: 'Set piece', 'Corner', 'Free kick', 'Penalty', 'Fastbreak', and 'Regular'. Accepts a character vector of length >= 1.
  \item \code{split_by_teams}: Logical indicator to group results by team.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{split_by_games}: Logical indicator to group results by game.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{general_position}: Describes the most common position played by each player over the specified period of time. Valid keywords include: 'GK', 'CB', 'FB', 'DM', 'CM', 'AM', 'W', and 'ST'. Accepts a character vector of length >= 1.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_player_xpass"></a>}}
\if{latex}{\out{\hypertarget{method-get_player_xpass}{}}}
\subsection{Method \code{get_player_xpass()}}{
Retrieves a data frame containing player xPass data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_player_xpass(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{minimum_minutes}: Minimum threshold for sum of minutes played.
  \item \code{minimum_passes}: Minimum threshold for sum of attempted passes.
  \item \code{player_ids}: Player IDs on which to filter. Cannot be combined with \code{player_names}. Accepts a character vector of length >= 1.
  \item \code{player_names}: Player names on which to filter. Partial matches are accepted. Cannot be combined with \code{player_ids}. Accepts a character vector of length >= 1.
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{pass_origin_third}: Describes the third of the field from which the pass originated. Valid keywords include: 'Attacking', 'Middle', and 'Defensive'. Accepts a character vector of length >= 1.
  \item \code{split_by_teams}: Logical indicator to group results by team.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{split_by_games}: Logical indicator to group results by game.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{general_position}: Describes the most common position played by each player over the specified period of time. Valid keywords include: 'GK', 'CB', 'FB', 'DM', 'CM', 'AM', 'W', and 'ST'. Accepts a character vector of length >= 1.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_player_goals_added"></a>}}
\if{latex}{\out{\hypertarget{method-get_player_goals_added}{}}}
\subsection{Method \code{get_player_goals_added()}}{
Retrieves a data frame containing player goals added (g+) data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_player_goals_added(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{minimum_minutes}: Minimum threshold for sum of minutes played.
  \item \code{player_ids}: Player IDs on which to filter. Cannot be combined with \code{player_names}. Accepts a character vector of length >= 1.
  \item \code{player_names}: Player names on which to filter. Partial matches are accepted. Cannot be combined with \code{player_ids}. Accepts a character vector of length >= 1.
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{split_by_teams}: Logical indicator to group results by team.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{split_by_games}: Logical indicator to group results by game.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{action_type}: Describes the goals added (g+) action type. Valid keywords include: 'Dribbling', 'Fouling', 'Interrupting', 'Passing', 'Receiving', and 'Shooting'. Accepts a character vector of length >= 1.
  \item \code{general_position}: Describes the most common position played by each player over the specified period of time. Valid keywords include: 'GK', 'CB', 'FB', 'DM', 'CM', 'AM', 'W', and 'ST'. Accepts a character vector of length >= 1.
  \item \code{above_replacement}: Logical indicator to compare players against replacement-level values. This will only return aggregated g+ values, rather than disaggregated g+ values by action type.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_goalkeeper_xgoals"></a>}}
\if{latex}{\out{\hypertarget{method-get_goalkeeper_xgoals}{}}}
\subsection{Method \code{get_goalkeeper_xgoals()}}{
Retrieves a data frame containing goalkeeper xG data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_goalkeeper_xgoals(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{minimum_minutes}: Minimum threshold for sum of minutes played.
  \item \code{minimum_shots_faced}: Minimum threshold for sum of shots faced.
  \item \code{player_ids}: Player IDs on which to filter. Cannot be combined with \code{player_names}. Accepts a character vector of length >= 1.
  \item \code{player_names}: Player names on which to filter. Partial matches are accepted. Cannot be combined with \code{player_ids}. Accepts a character vector of length >= 1.
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{shot_pattern}: Describes the possessing actions leading to the shot. Valid keywords include: 'Set piece', 'Corner', 'Free kick', 'Penalty', 'Fastbreak', and 'Regular'. Accepts a character vector of length >= 1.
  \item \code{split_by_teams}: Logical indicator to group results by team.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{split_by_games}: Logical indicator to group results by game.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_goalkeeper_goals_added"></a>}}
\if{latex}{\out{\hypertarget{method-get_goalkeeper_goals_added}{}}}
\subsection{Method \code{get_goalkeeper_goals_added()}}{
Retrieves a data frame containing goalkeeper goals added (g+) data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_goalkeeper_goals_added(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{minimum_minutes}: Minimum threshold for sum of minutes played.
  \item \code{player_ids}: Player IDs on which to filter. Cannot be combined with \code{player_names}. Accepts a character vector of length >= 1.
  \item \code{player_names}: Player names on which to filter. Partial matches are accepted. Cannot be combined with \code{player_ids}. Accepts a character vector of length >= 1.
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{split_by_teams}: Logical indicator to group results by team.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{split_by_games}: Logical indicator to group results by game.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{action_type}: Describes the goals added (g+) action type. Valid keywords include: 'Claiming', 'Fielding', 'Handling', 'Passing', 'Shotstopping', and 'Sweeping'. Accepts a character vector of length >= 1.
  \item \code{above_replacement}: Logical indicator to compare players against replacement-level values. This will only return aggregated g+ values, rather than disaggregated g+ values by action type.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_team_xgoals"></a>}}
\if{latex}{\out{\hypertarget{method-get_team_xgoals}{}}}
\subsection{Method \code{get_team_xgoals()}}{
Retrieves a data frame containing team xG data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_team_xgoals(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{shot_pattern}: Describes the possessing actions leading to the shot. Valid keywords include: 'Set piece', 'Corner', 'Free kick', 'Penalty', 'Fastbreak', and 'Regular'. Accepts a character vector of length >= 1.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{split_by_games}: Logical indicator to group results by game.
  \item \code{home_only}: Logical indicator to only include results from home games.
  \item \code{away_only}: Logical indicator to only include results from away games.
  \item \code{home_adjusted}: Logical indicator to adjust certain values based on the share of home games a team has played during the specified duration.
  \item \code{even_game_state}: Logical indicator to only include shots taken when the score was level.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_team_xpass"></a>}}
\if{latex}{\out{\hypertarget{method-get_team_xpass}{}}}
\subsection{Method \code{get_team_xpass()}}{
Retrieves a data frame containing team xPass data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_team_xpass(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{pass_origin_third}: Describes the third of the field from which the pass originated. Valid keywords include: 'Attacking', 'Middle', and 'Defensive'. Accepts a character vector of length >= 1.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{split_by_games}: Logical indicator to group results by game.
  \item \code{home_only}: Logical indicator to only include results from home games.
  \item \code{away_only}: Logical indicator to only include results from away games.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_team_goals_added"></a>}}
\if{latex}{\out{\hypertarget{method-get_team_goals_added}{}}}
\subsection{Method \code{get_team_goals_added()}}{
Retrieves a data frame containing team goals added (g+) data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_team_goals_added(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{team_ids}: Team IDs on which to filter. Cannot be combined with \code{team_names}. Accepts a character vector of length >= 1.
  \item \code{team_names}: Team names on which to filter. Partial matches and abbreviations are accepted. Cannot be combined with \code{team_ids}. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{split_by_seasons}: Logical indicator to group results by season.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{action_type}: Describes the goals added (g+) action type. Valid keywords include: 'Dribbling', 'Fouling', 'Interrupting', 'Passing', 'Receiving', and 'Shooting'. Accepts a character vector of length >= 1.
  \item \code{zone}: Zone number on pitch. Zones 1-5 are the defensive-most zones, and zones 26-30 are the attacking-most zones. Accepts a character or integer vector of length >= 1.
  \item \code{gamestate_trunc}: Integer (score differential) value between -2 and 2, inclusive. Gamestates more extreme than -2 and 2 have been included with -2 and 2, respectively. Accepts a character or integer vector of length >= 1.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_game_xgoals"></a>}}
\if{latex}{\out{\hypertarget{method-get_game_xgoals}{}}}
\subsection{Method \code{get_game_xgoals()}}{
Retrieves a data frame containing game xG data meeting the specified conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$get_game_xgoals(leagues, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leagues}}{Leagues on which to filter. Accepts a character vector of length >= 1.}

\item{\code{...}}{The following arguments will be parsed:
\itemize{
  \item \code{game_ids}: Game IDs on which to filter. Accepts a character vector of length >= 1.
  \item \code{season_name}: Name(s)/year(s) of seasons. Cannot be combined with a date range. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
  \item \code{start_date}: Start of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{end_date}: End of a date range. Must be a string in YYYY-MM-DD format. Cannot be combined with \code{season_name}.
  \item \code{stage_name}: Describes the stage of competition in which a game took place. See the \href{https://app.americansocceranalysis.com/api/v1/__docs__/}{API documentation} for possible values. Accepts a character vector of length >= 1.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AmericanSoccerAnalysis$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
