% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.FormatOccurrence}
\alias{print.FormatOccurrence}
\title{Print summary information from \code{FormatOccurrence} object.}
\usage{
\method{print}{FormatOccurrence}(x, ...)
}
\arguments{
\item{x}{(\code{FormatOccurrence}) A \code{FormatOccurrence} object to be messaged.
It could be the return of function \code{\link{format_observation}}.}

\item{...}{Not used.}
}
\value{
The same object that was passed as input.
}
\description{
Display the type and number of training and evaluation dataset
in the formatted observations obtained by
function \code{\link{format_observation}}.
}
\examples{
\donttest{
library(dplyr)
library(itsdm)
data("occ_virtual_species")

# obs + eval, presence-absence
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"
obs_type <- "presence_absence"

obs_formatted <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = obs_type)

print(obs_formatted)
}

}
\seealso{
\code{\link{format_observation}}
}
