% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.PAConversion}
\alias{print.PAConversion}
\title{Print summary information from \code{PAConversion} object.}
\usage{
\method{print}{PAConversion}(x, ...)
}
\arguments{
\item{x}{(\code{PAConversion}) A PAConversion object to be messaged.
It could be the return of function \code{\link{convert_to_pa}}.}

\item{...}{Not used.}
}
\value{
The same object that was passed as input.
}
\description{
Display the equation and parameters of a \code{PAConversion} object.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

# Threshold conversion
pa_thred <- convert_to_pa(mod$prediction, method = 'threshold', beta = 0.5)
print(pa_thred)
}

}
\seealso{
\code{\link{convert_to_pa}}, \code{\link{plot.PAConversion}}
}
