% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monobound.R
\name{diffA}
\alias{diffA}
\title{Taking first differences of constraint matrices}
\usage{
diffA(A, monogrid, sn, d, ndcols)
}
\arguments{
\item{A}{a design matrix that evaluates the MTRs over the grid
generated for the audit procedure.}

\item{monogrid}{the grid generated for the audit procedure, sorted
by the values of the covariates, and monotone increasing in the
unobservable.}

\item{sn}{the number of binding constraints in the S-set.}

\item{d}{indicator for treatment group (\code{d=1}) versus control
group (\code{d = 0}).}

\item{ndcols}{number of terms in the MTR for the other experimental
group. This is used to generate a matrix that is of the correct
dimension.}
}
\value{
a matrix representing the monotonicity restrictions.
}
\description{
This function takes in the matrix of values of the MTR evaluated
over the grid generated for the audit procedure. The grid is
ordered according to the covariates first, and then by the
unobservables (this is done in by \code{\link{genmonoA}}). This
function takes the first difference of the unobservables within
each set of values for the covariates. This is sufficient to
generate the monotonicity constraint matrix.
}
