% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivlike.R
\name{ivEstimate}
\alias{ivEstimate}
\title{Obtaining IV-like specifications}
\usage{
ivEstimate(formula, data, subset, components, treat, list = FALSE)
}
\arguments{
\item{formula}{formula to be estimated using OLS/IV.}

\item{data}{\code{data.frame} with which to perform the estimation.}

\item{subset}{subset condition with which to perform the estimate.}

\item{components}{vector of variable names whose coefficients we
want to include in the set of IV-like estimands.}

\item{treat}{name of treatment indicator variable.}

\item{list}{logical, set to TRUE if this function is being used to
loop over a list of formulas.}
}
\value{
Returns a list containing the matrices of IV-like
    specifications for \code{D = 0} and \code{D = 1}; and the
    estimates of the IV-like estimands.
}
\description{
This function estimates the IV-like estimands, as well as generates
the IV-like specifications.
}
\examples{
ivEstimate(formula = ey ~ d | z,
           data = dtm,
           components = l(d),
           treat = d,
           list = FALSE)
}
