% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relation.R
\name{relation-detect}
\alias{relation-detect}
\alias{iv_overlaps}
\alias{iv_precedes}
\alias{iv_follows}
\title{Detect a relationship between two ivs}
\usage{
iv_overlaps(needles, haystack, ..., type = "any", missing = "equals")

iv_precedes(needles, haystack, ..., missing = "equals")

iv_follows(needles, haystack, ..., missing = "equals")
}
\arguments{
\item{needles}{\verb{[iv]}

Interval vectors used for relation matching.
\itemize{
\item Each element of \code{needles} represents the interval to search for.
\item \code{haystack} represents the intervals to search in.
}

Prior to comparison, \code{needles} and \code{haystack} are coerced to the same type.}

\item{haystack}{\verb{[iv]}

Interval vectors used for relation matching.
\itemize{
\item Each element of \code{needles} represents the interval to search for.
\item \code{haystack} represents the intervals to search in.
}

Prior to comparison, \code{needles} and \code{haystack} are coerced to the same type.}

\item{...}{These dots are for future extensions and must be empty.}

\item{type}{\verb{[character(1)]}

The type of relationship to find. One of:
\itemize{
\item \code{"any"}: Finds any overlap whatsoever between an interval in \code{needles}
and an interval in \code{haystack}.
\item \code{"within"}: Finds when an interval in \code{needles} is completely within
(or equal to) an interval in \code{haystack}.
\item \code{"contains"}: Finds when an interval in \code{needles} completely contains
(or equals) an interval in \code{haystack}.
\item \code{"equals"}: Finds when an interval in \code{needles} is exactly equal to
an interval in \code{haystack}.
\item \code{"starts"}: Finds when the start of an interval in \code{needles} matches the
start of an interval in \code{haystack}.
\item \code{"ends"}: Finds when the end of an interval in \code{needles} matches the end
of an interval in \code{haystack}.
}}

\item{missing}{\verb{[logical(1) / "equals" / "error"]}

Handling of missing intervals in \code{needles}.
\itemize{
\item \code{"equals"} considers missing intervals in \code{needles} as exactly equal
to missing intervals in \code{haystack} when determining if there is a
matching relationship between them. Matched missing intervals in
\code{needles} result in a \code{TRUE} value in the result, and unmatched missing
intervals result in a \code{FALSE} value.
\item \code{"error"} throws an error if any intervals in \code{needles} are missing.
\item If a single logical value is provided, this represents the value returned
in the result for intervals in \code{needles} that are missing. You can force
missing intervals to be unmatched by setting this to \code{FALSE}, and you
can force them to be propagated by setting this to \code{NA}.
}}
}
\value{
A logical vector the same size as \code{needles}.
}
\description{
This family of functions detects different types of relationships between
two ivs. It works similar to \link[base:match]{base::\%in\%}, where \code{needles[i]} checks for
a relationship in all of \code{haystack}.
\itemize{
\item \code{iv_overlaps()} detects a specific \code{type} of overlap between the two ivs.
\item \code{iv_precedes()} detects if \code{needles[i]} precedes (i.e. comes before) any
interval in \code{haystack}.
\item \code{iv_follows()} detects if \code{needles[i]} follows (i.e. comes after) any
interval in \code{haystack}.
}

These functions return a logical vector the same size as \code{needles} containing
\code{TRUE} if the interval in \code{needles} has a matching relationship in
\code{haystack} and \code{FALSE} otherwise.
}
\examples{
library(vctrs)

x <- iv_pairs(
  as.Date(c("2019-01-05", "2019-01-10")),
  as.Date(c("2019-01-07", "2019-01-15")),
  as.Date(c("2019-01-20", "2019-01-31"))
)

y <- iv_pairs(
  as.Date(c("2019-01-01", "2019-01-03")),
  as.Date(c("2019-01-04", "2019-01-08")),
  as.Date(c("2019-01-07", "2019-01-09")),
  as.Date(c("2019-01-10", "2019-01-20")),
  as.Date(c("2019-01-15", "2019-01-20"))
)

x
y

# Does each interval of `x` overlap `y` at all?
iv_overlaps(x, y)

# Which intervals of `y` are within an interval in `x`?
iv_overlaps(y, x, type = "within")

# ---------------------------------------------------------------------------

a <- iv(c(1, NA), c(2, NA))
b <- iv(c(NA, NA), c(NA, NA))

# Missing intervals are seen as exactly equal by default, so they are
# considered to overlap
iv_overlaps(a, b)

# If you'd like missing intervals to be treated as unmatched, set
# `missing = FALSE`
iv_overlaps(a, b, missing = FALSE)

# If you'd like to propagate missing intervals, set `missing = NA`
iv_overlaps(a, b, missing = NA)
}
\seealso{
\link[=relation-locate]{Locating relationships}

\link[=relation-detect-pairwise]{Detecting relationships pairwise}

\link[=allen-relation-locate]{Locating relations from Allen's Interval Algebra}
}
