% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.R
\name{inv_logit}
\alias{inv_logit}
\title{Generalized inverse logit function}
\usage{
inv_logit(x, min = 0, max = 1)
}
\arguments{
\item{x}{value(s) to be transformed}

\item{min}{Lower end of logit interval}

\item{max}{Upper end of logit interval}
}
\value{
y Transformed value(s).
}
\description{
Compute generalized inverse logit function.
}
\details{
The generalized inverse logit function takes values on [-Inf,Inf] and transforms them to span [min, max] :
\deqn{y = p' (max-min) + min}{y = p * (max-min) + min} 
\deqn{where}
\deqn{p =\frac{exp(x)}{(1+exp(x))}}{p =exp(x)/(1+exp(x))}
}
\examples{
x <- seq(0,10, by=0.25)
xt <- jSDM::logit(x, min=0, max=10)
cbind(x,xt)
y <- jSDM::inv_logit(xt, min=0, max=10)
cbind(x,xt,y)  
}
\author{
{Gregory R. Warnes <greg@warnes.net>}
}
\keyword{logistic}
\keyword{logit}
\keyword{math}
