\name{dm.addMutationRateHeterogenity}
\alias{dm.addMutationRateHeterogenity}
\title{Allows the mutation rate on different sites to vary according to
a Gamma Distribution.}
\usage{
dm.addMutationRateHeterogenity(dm, min.alpha, max.alpha, fixed.alpha,
  par.new = T, new.par.name = "alpha", parameter, categories.number)
}
\arguments{
  \item{dm}{The demographic model to which the rate
  heterogeneity should be added.}

  \item{par.new}{If 'TRUE' a new parameter will be created
  using the arguments 'min.alpha' and 'max.alpha' or
  'fixed.alpha'. It will be named 'new.par.name' If 'FALSE'
  the argument 'parameter' will be evaluated instead.}

  \item{min.alpha}{If you want to estimate the rate
  heterogeneity, this will be used as the smallest possible
  value.}

  \item{max.alpha}{Same as min.growth.rate, but the largest
  possible value.}

  \item{fixed.alpha}{If specified, the growth rate will not
  be estimated, but assumed to have the given value.}

  \item{new.par.name}{Name for the new parameter.  occurs.
  See \link{dm.addSpeciationEvent} for more information.}

  \item{categories.number}{If this is set, a fixed number
  of categories will be used to model the gamma
  distribution instead of drawing every parameter
  seperately (see text).}

  \item{parameter}{Instead of creating a new parameter, you
  can also set the mutation rate to an expression based on
  existing parameters. For example setting this to "alpha"
  will use a parameter with name alpha that you have
  previously created. You can also use R expression here,
  i.e. "2*alpha" or "5*M+2*alpha" (if M is another
  parameter) will also work (also the latter does not make
  much sense).}
}
\value{
The demographic model with a size change.
}
\description{
This function adds a Gamma distributed rate heterogeneity
as implemented in 'seq-gen' to the model.
}
\details{
"The [...] model of rate heterogeneity assigns different
rates to different sites according to a gamma distribution
(Yang, 1993). The distribution is scaled such that the mean
rate for all the sites is 1 but the user must supply a
parameter which describes its shape. A low value for this
parameter (<1.0) simulates a large degree of site-specific
rate heterogeneity and as this value increases the
simulated data becomes more rate-homogeneous. This can be
performed as a continuous model, i.e. every site has a
different rate sampled from the gamma distribution of the
given shape, or as a discrete model, i.e. each site falls
into one of N rate categories approximating the gamma
distribution. For a review of site-specific rate
heterogeneity and its implications for phylogenetic
analyses, see Yang (1996)." [From the seq-gen homepage
http://bioweb2.pasteur.fr/docs/seq-gen ]

The Parameter in this text will be referred to as 'alpha'.
Simulation a model with rate heterogeneity requires that
'seq-gen' is installed on your system.
}
\examples{
# A model with one smaller population
dm <- dm.createThetaTauModel(c(20,37), 88)
dm <- dm.setMutationModel(dm, "HKY")
dm <- dm.addMutationRateHeterogenity(dm, 0.1, 5, new.par.name="alpha")
}

