% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jabr_fetch_group.R
\name{jabr_fetch_group}
\alias{jabr_fetch_group}
\title{Fetch group of datasets}
\usage{
jabr_fetch_group(group_id, keep_title = TRUE, as = "table")
}
\arguments{
\item{group_id}{The group id of dataset. It only accepts single group id.}

\item{keep_title}{Whether to keep the dataset title in result. If the result is a table, the title is saved in "title" column. If the result is a list, the title is saved as list name.}

\item{as}{If \code{as = "table"}, the fetched datasets will be saved in "dataset" column with list-column type where you can run \code{tidyr::unnest()} afterwards. Otherwise the fetched datasets will be saved as list.}
}
\value{
A tibble or list of tibble.
}
\description{
Download and parse the dataset available at Open Data Jawa Barat into R. This function will download multiple datasets which have same \code{group_id}.
}
\examples{
\donttest{
library(jabr)

(x <- jabr_list_dataset())


# for example, we want to fetch data about gini ratio in west java since 2011 to 2017.
# The group_id of this data is "78358b54".
jabr_fetch_group("78358b54") \%>\%
  tidyr::unnest(cols = c(dataset))
}

}
