% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zonal.R
\name{Zonal}
\alias{Zonal}
\title{Evaluation of zonal polynomials}
\usage{
Zonal(x, lambda, algorithm = "DK")
}
\arguments{
\item{x}{numeric or complex vector or \link[gmp]{bigq} vector}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{algorithm}{the algorithm used, either \code{"DK"} (Demmel-Koev)
or \code{"naive"}}
}
\value{
A numeric or complex scalar or a \code{bigq} rational number.
}
\description{
Evaluates a zonal polynomial.
}
\examples{
lambda <- c(2,2)
Zonal(c(1,1), lambda)
Zonal(c(gmp::as.bigq(1),gmp::as.bigq(1)), lambda)
##
x <- c(3,1)
Zonal(x, c(1,1)) + Zonal(x, 2) # sum(x)^2
Zonal(x, 3) + Zonal(x, c(2,1)) + Zonal(x, c(1,1,1)) # sum(x)^3
}
\references{
\itemize{
\item Robb Muirhead. \emph{Aspects of multivariate statistical theory}.
Wiley series in probability and mathematical statistics.
Probability and mathematical statistics.
John Wiley & Sons, New York, 1982.
\item Akimichi Takemura. \emph{Zonal Polynomials},
volume 4 of Institute of Mathematical Statistics Lecture Notes –
Monograph Series.
Institute of Mathematical Statistics, Hayward, CA, 1984.
\item Lin Jiu & Christoph Koutschan.
\emph{Calculation and Properties of Zonal Polynomials}.
\url{http://koutschan.de/data/zonal/}
}
}
\seealso{
\code{\link{ZonalPol}}
}
