
print.jagsUI <- function(x,digits=3,...){
  
  #bugs.format=TRUE prints a nearly exact replica of WinBUGS-style output
  
  #Header
  if(!x$bugs.format){
    cat('JAGS output for model \'',x$modfile,'\', generated by jagsUI.','\n',sep="")
    cat('Estimates based on',x$mcmc.info$n.chains,'chains of',x$mcmc.info$n.iter,'iterations,\n') 
    cat('burn-in = ',x$mcmc.info$n.burnin,' iterations and thin rate = ',x$mcmc.info$n.thin,',','\n',sep="")
    cat('yielding',x$mcmc.info$n.samples,'total samples from the joint posterior.','\n')
    if(!x$parallel){cat('MCMC ran for ',x$mcmc.info$elapsed.mins,' minutes at time ',paste(x$run.date),'.\n','\n',sep="")
    } else{cat('MCMC ran in parallel for ',x$mcmc.info$elapsed.mins,' minutes at time ',paste(x$run.date),'.\n','\n',sep="")}
  } else{
    cat('Inference for Bugs model at \'',x$modfile,'\', fit using JAGS,','\n',sep="")
    cat(x$mcmc.info$n.chains,'chains, each with',x$mcmc.info$n.iter,'iterations (first ',x$mcmc.info$n.burnin,'discarded), n.thin =',x$mcmc.info$n.thin) 
    cat('\nn.sims =',x$mcmc.info$n.samples,'iterations saved','\n')    
  }
  
  #Organize columns
  if(!x$bugs.format){
    if(x$mcmc.info$n.chains!=1){y = x$summary[,c(1,2,3,5,7,10,11,8,9)]
    } else {y = x$summary[,c(1,2,3,5,7,8,9)]}
    z <-  as.data.frame(round(as.matrix(y),digits))
    if(is.vector(y)){
      z <- as.data.frame(t(z))
      row.names(z) <- rownames(x$summary)
    }
    z[,6] <- z[,6]==1
  } else {
    if(x$mcmc.info$n.chains!=1){y = x$summary[,c(1:9)]
    } else {y = x$summary[,c(1:7)]}
    z <- as.data.frame(round(as.matrix(y),digits))
    if(is.vector(y)){
      z <- as.data.frame(t(z))
      row.names(z) <- rownames(x$summary)
    }
  }
  
  #print the output
  print(z)
  
  #Print Rhat/n.eff information if necessary
  if(x$mcmc.info$n.chains>1){
    if(!x$bugs.format){
      if(max(unlist(x$Rhat),na.rm=TRUE)>1.1){cat('\n**WARNING** Rhat values indicate convergence failure.','\n')
      }else{cat('\nSuccessful convergence based on Rhat values (all < 1.1).','\n')}
      cat('Rhat is the potential scale reduction factor (at convergence, Rhat=1).','\n')
      cat('For each parameter, n.eff is a crude measure of effective sample size.','\n')
    } else {
      cat('\nFor each parameter, n.eff is a crude measure of effective sample size,','\n')
      cat('and Rhat is the potential scale reduction factor (at convergence, Rhat=1).','\n')
    }
  }
  
  #Print overlap0/f statistic info
  if(!x$bugs.format){
  cat('\noverlap0 checks if 0 falls in the parameter\'s 95% credible interval.\n')
  cat('f is the proportion of the posterior with the same sign as the mean;\n')
  cat('i.e., our confidence that the parameter is positive or negative.\n')
  }
  
  #Print DIC info
  if(!is.null(x$DIC)){    
    if(!x$bugs.format){
      cat('\nDIC info: (pD = var(deviance)/2)','\npD =',round(x$pD,1),'and DIC =',round(x$DIC,digits),'\n')
      cat('DIC is an estimate of expected predictive error (lower is better).\n')
    } else {
      cat('\nDIC info (using the rule, pD = var(deviance)/2)','\npD =',round(x$pD,1),'and DIC =',round(x$DIC,digits),'\n')
      cat('DIC is an estimate of expected predictive error (lower deviance is better).\n')
    }
  }
    
    
}