% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{ts_postpred}
\alias{ts_postpred}
\title{Time series plot of centered posterior predictive distribution}
\usage{
ts_postpred(
  ypp,
  y,
  p = NULL,
  x = NULL,
  lines = FALSE,
  pch = 1,
  pointcol = 1,
  transform = c("none", "exp", "expit"),
  ...
)
}
\arguments{
\item{ypp}{Either a matrix or \code{data.frame} of posterior samples, or an
output object returned from \code{jagsUI} and a supplied parameter name}

\item{y}{The associated data vector}

\item{p}{A character name, if a \code{jagsUI} object is passed to \code{ypp}}

\item{x}{The time measurements associated with time series \code{y}.  If the default
\code{NULL} is accepted, equally-spaced integer values will be used.}

\item{lines}{Whether to add a line linking data time series points.  Defaults to \code{FALSE}.}

\item{pch}{Plotting character for points, which will accept a vector input.
See \link[graphics]{points}.  Defaults to \code{1}.}

\item{pointcol}{Plotting color for points.  Defaults to \code{1}.}

\item{transform}{Should the y-axis be (back)transformed?  Options are \code{"exp"},
indicating exponential, or \code{"expit"}, indicating inverse-logit. Defaults to
\code{"none"}, indicating no transformation.  Note: if \code{transform="exp"}is used, consider
adding additional plotting argument \code{log="y"}.}

\item{...}{Additional arguments to \link{envelope}}
}
\value{
\code{NULL}
}
\description{
Produces a plot of centered posterior predictive distributions
associated with a vector of data (most likely a time series),
defined as the difference between posterior predictive and posterior predictive
median.

Also overlays the posterior predictive residuals, defined as the differences
between data values and their respective posterior predictive medians.

While not an omnibus posterior predictive check, this plot can be useful
for detecting an overparameterized model, or else improper specification
of observation error.

It should be noted that this function will only produce meaningful results
with a vector of data, as opposed to a single value.

The posterior predictive distribution can be specified in two possible ways:
either a single output object from \code{jagsUI} with an associated parameter
name, or as a matrix or \code{data.frame} of posterior samples.
}
\note{
This function assumes the existence of a matrix of posterior predictive
samples corresponding to a data vector, the construction of which must be
left to the user.  This can be accomplished within JAGS, or using appropriate
simulation from the posterior samples.
}
\examples{
# first, a quick look at the example data...
str(SS_data)
str(SS_out$sims.list$ypp)

# plotting the example posterior predictive distribution with the data
# points overlayed.  Note the overdispersion in the posterior predictive.
caterpillar(SS_out, p="ypp")
points(SS_data$y)

# using a jagsUI object as ypp input
ts_postpred(ypp=SS_out, p="ypp", y=SS_data$y)

# using a matrix as ypp input
ts_postpred(ypp=SS_out$sims.list$ypp, y=SS_data$y)

# exp transformation
ts_postpred(ypp=SS_out, p="ypp", y=SS_data$y, transform="exp")
ts_postpred(ypp=SS_out, p="ypp", y=SS_data$y, transform="exp", log="y")
}
\seealso{
\link{qq_postpred}, \link{plot_postpred}, \link{check_Rhat}, \link{check_neff}, \link{traceworstRhat}, \link{plotRhats}
}
\author{
Matt Tyers
}
