% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{col2hcl}
\alias{col2hcl}
\title{convert R color to HCL color matrix}
\usage{
col2hcl(
  x,
  maxColorValue = 255,
  model = getOption("jam.model", c("hcl", "polarLUV", "polarLAB")),
  ...
)
}
\arguments{
\item{x}{\code{character} R compatible color, either a color name, hex value, or
a mixture of the two. Any value compatible with
\code{grDevices::col2rgb()}.}

\item{maxColorValue}{\code{numeric} maximum value to return, useful
when the downstream alpha range should be 255.
By default maxValue=1 is returned.}

\item{model}{\code{character} color model to use
\itemize{
\item \code{"hcl"} to use \code{farver} HCL
\item \code{"polarLUV"} for the standard R conventional HCL,
\item \code{"polarLAB"} which uses the LAB-based HCL values.
}}

\item{...}{additional arguments are ignored.}
}
\value{
\code{numeric} matrix with H, C, L values.
}
\description{
convert R color to HCL color matrix
}
\details{
This function takes an R color and converts to an HCL matrix, using
the colorspace package, and \code{\link[colorspace]{RGB}} and
\code{\link[colorspace]{polarLUV}} functions. It is also used to
maintain alpha transparency, to enable interconversion via other
color manipulation functions as well.

When \code{model="hcl"} this function uses \code{farver::decode_colour()}
and bypasses \code{colorspace}. In future the \code{colorspace} dependency
will likely be removed in favor of using \code{farver}. In any event,
\code{model="hcl"} is equivalent to using \code{model="polarLUV"} and
\code{fixup=TRUE}, except that it should be much faster.
}
\examples{
col2hcl("#FF000044")

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
