% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{jargs}
\alias{jargs}
\title{Show R function arguments jam-style}
\usage{
jargs(
  x,
  grepString = NULL,
  sortVars = FALSE,
  useMessage = TRUE,
  asList = TRUE,
  useColor = TRUE,
  lightMode = NULL,
  Crange = getOption("jam.Crange"),
  Lrange = getOption("jam.Lrange"),
  adjustRgb = getOption("jam.adjustRgb"),
  useCollapseBase = ", ",
  verbose = FALSE,
  debug = 0,
  ...
)
}
\arguments{
\item{x}{\code{function} or character name of a function.}

\item{grepString}{\code{NULL}, \code{logical}, or \code{character} grep regular expression
pattern used to filter function arguments by name. Very useful to
search a function for arguments with a substring \code{"row"}.
\itemize{
\item If \code{logical}, it is assumed to be sortVars, and indicates whether
to sort the parameter names.
\item if \code{character} it will subset the function arguments by name matching
this regular expression pattern.
}}

\item{sortVars}{\code{logical} whether to sort the function parameter names.
\itemize{
\item \code{sortVars=FALSE} returns arguments in the order they appear in the
function definition.
\item \code{sortVars=TRUE} returns arguments sorted alphabetically.
}}

\item{useMessage}{\code{logical} default TRUE, whether to print output
using \code{message()}, otherwise text is returned invisibly to be
displayed separately.}

\item{asList}{\code{logical} default TRUE, display one entry per line or
display results as a \code{data.frame}.}

\item{useColor}{\code{logical} whether to display results in color, if the crayon
package is available, and terminal console is capable.}

\item{lightMode}{\code{logical} or \code{NULL}, indicating whether the text background
color is light, thus imposing a maximum brightness for colors displayed.
It use lightMode if defined by the function caller, otherwise it will
use \code{getOption("jam.lightMode")} if defined, lastly it will attempt to
detect whether running inside Rstudio by checking the environment variable
"RSTUDIO", and if so it will assume lightMode==TRUE.}

\item{Crange}{\code{numeric} range of chroma values, ranging
between 0 and 100. When NULL, default values will be
assigned to Crange by \code{setCLranges()}.}

\item{Lrange}{\code{numeric} range of luminance values, ranging
between 0 and 100. When NULL, default values will be
assigned to Lrange by \code{setCLranges()}.}

\item{adjustRgb}{\code{numeric} value adjustment used during the conversion of
RGB colors to ANSI colors, which is inherently lossy. If not defined,
it uses the default returned by \code{setCLranges()} which itself uses
\code{getOption("jam.adjustRgb")} with default=0. In order to boost
color contrast, an alternate value of -0.1 is suggested.}

\item{useCollapseBase}{\code{character} string used to combine multiple parameter
values.}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{debug}{\code{integer} value, greater than 0 will cause debug-type verbose
output, useful because parameters are hard!}

\item{...}{Additional arguments are installed.}
}
\value{
\code{NULL} this function called for the byproduct of printing
its output.
}
\description{
Show R function arguments jam-style
}
\details{
This function displays R function arguments, organized with one argument
per line, and colorized using the \code{crayon} package if
installed.

Output is nicely spaced to help visual alignment of argument names
and argument values.

Output can be filtered by \code{character} pattern. For example the
function \code{ComplexHeatmap::Heatmap()} is amazing, and offers numerous
arguments. To find arguments relevant to dendrograms, use \code{"dend"}:

\code{jargs(ComplexHeatmap::Heatmap, "dend")}

NOTE: This function has edge case issues displaying complex function
argument values such as nested lists and custom functions.
In that case the argument name is printed as usual, and the argument value
is displayed as a partial snippet of the default argument value.

Generic functions very often contain no useful parameters,
making it difficult to discover required
parameters without reading the function documentation from the proper
dispatched function and calling package. In that case,
try using \code{jargs(functionname.default)} for example compare:

\code{jargs(barplot)}

to:

\code{jargs(barplot.default)}
}
\examples{
args(jargs)
jargs(jargs)

# retrieve parameters involving notes from imageByColors
jargs(imageByColors, "note")

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
