% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{unigrep}
\alias{unigrep}
\title{case-insensitive grep, returning unmatched indices}
\usage{
unigrep(..., ignore.case = TRUE, invert = TRUE)
}
\arguments{
\item{..., ignore.case, invert}{parameters sent to \code{base::grep()}}
}
\value{
vector of non-matching indices
}
\description{
case-insensitive grep, returning unmatched indices
}
\details{
This function is a simple wrapper around \code{base::grep()} which
runs in case-insensitive mode, and returns unmatched entries.
It is mainly used to save keystrokes,
but is consistently named alongside \code{\link{vgrep}} and
\code{\link{vigrep}}, and quite helpful for writing concise code.
}
\examples{
V <- paste0(LETTERS[1:5], LETTERS[4:8]);
unigrep("D", V);
igrep("D", V);

}
\seealso{
Other jam grep functions: 
\code{\link{grepls}()},
\code{\link{igrep}()},
\code{\link{igrepHas}()},
\code{\link{igrepl}()},
\code{\link{provigrep}()},
\code{\link{unvigrep}()},
\code{\link{vgrep}()},
\code{\link{vigrep}()}
}
\concept{jam grep functions}
