% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data.R
\name{getBestSolutionValues}
\alias{getBestSolutionValues}
\title{Get values of best found solutions}
\usage{
getBestSolutionValues(data, problem, search)
}
\arguments{
\item{data}{data object containing the analysis results}

\item{problem}{name of the analyzed problem. Can be omitted if the
\code{data} contains results for a single problem only.}

\item{search}{name of the applied search. Can be omitted if the \code{data}
  contains results for a single search only (for the considered
  \code{problem}).}
}
\value{
Numeric vector containing the values of the best found solutions
  during each run.
}
\description{
Get the values of the best found solutions during all runs of the given
\code{search} applied to the given \code{problem}. This is a generic S3
method.
}
\details{
If the \code{data} contains results for a single problem only, the argument
\code{problem} can be omitted. Likewise, if for the considered \code{problem}
results are available for a single search only, the argument \code{search}
can be omitted.
}

