% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data.R
\name{readJAMES}
\alias{readJAMES}
\title{Read analysis results from JSON file}
\usage{
readJAMES(file)
}
\arguments{
\item{file}{string: path to a JSON file containing results produced by the
analysis tools from the `JAMES' extensions module.}
}
\value{
S3 object of class "james" containing the results of running a number
  of searches on a set of problems, where each search has been repeatedly
  applied for a number of runs. Data can be manipulated and extracted using
  the provided functions (see below).
}
\description{
Read results from a JSON file produced by the analysis tools in the `JAMES'
extensions module.
}
\examples{
# get path to raw JSON file included in package distribution
json.file <- system.file("extdata", "james.json", package = "james.analysis")

# read results from file
james <- readJAMES(json.file)
summary(james)

# plot convergence curves for coconut data set
plotConvergence(james, problem = "coconut", min.time = 1000, max.time = 100000)

# create box plots of solution values (quality) and convergence times
boxplot(james, problem = "coconut")
boxplot(james, problem = "coconut", type = "time")

# extract solution values and convergence times for parallel tempering and random descent
values.pt <- getBestSolutionValues(james, problem = "coconut", search = "Parallel Tempering")
times.pt <- getConvergenceTimes(james, problem = "coconut", search = "Parallel Tempering")
values.rd <- getBestSolutionValues(james, problem = "coconut", search = "Random Descent")
times.rd <- getConvergenceTimes(james, problem = "coconut", search = "Random Descent")

# perform wilcoxon test to compare distributions across algorithms
values.test <- wilcox.test(values.pt, values.rd)
values.test
times.test <- wilcox.test(times.pt, times.rd)
times.test

# adjust p-values for multiple testing
p.adjust(c(values.test$p.value, times.test$p.value))
}
\seealso{
Example data: \code{\link{james}}.

  Data access and manipulations methods: \code{\link{reduceJAMES}},
  \code{\link{mergeJAMES}}, \code{\link{getProblems}},
  \code{\link{getSearches}}, \code{\link{getSearchRuns}},
  \code{\link{getNumSearchRuns}}, \code{\link{getBestSolutionValues}},
  \code{\link{getBestSolutions}}, \code{\link{getConvergenceTimes}}.

  Plot functions: \code{\link{plotConvergence}}, \code{\link{boxplot.james}}.
}

