% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_empties.R
\name{remove_constant}
\alias{remove_constant}
\title{Remove constant columns from a data.frame or matrix.}
\usage{
remove_constant(dat, na.rm = FALSE)
}
\arguments{
\item{dat}{the input data.frame or matrix.}

\item{na.rm}{should \code{NA} values be removed when considering whether a 
column is constant?  The default value of \code{FALSE} will result in a column 
not being removed if it's a mix of a single value and \code{NA}.}
}
\description{
Remove constant columns from a data.frame or matrix.
}
\examples{
remove_constant(data.frame(A=1, B=1:3))

# To find the columns that are constant
data.frame(A=1, B=1:3) \%>\%
  dplyr::select_at(setdiff(names(.), names(remove_constant(.)))) \%>\%
  unique()
}
\seealso{
\code{\link[=remove_empty]{remove_empty()}} for removing empty 
columns or rows.

Other remove functions: \code{\link{remove_empty}}
}
\concept{remove functions}
