% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b3lmeta.R
\name{b3lmeta}
\alias{b3lmeta}
\title{Bayesian Meta-Analysis for Combining Studies}
\usage{
b3lmeta(
  data,
  mean.mu.0 = 0,
  sd.mu.0 = 10,
  scale.sigma.between = 0.5,
  df.scale.between = 1,
  scale.sigma.within = 0.5,
  df.scale.within = 1,
  nr.chains = 2,
  nr.iterations = 10000,
  nr.adapt = 1000,
  nr.burnin = 1000,
  nr.thin = 1,
  be.quiet = FALSE,
  r2jags = TRUE
)
}
\arguments{
\item{data}{A data frame with at least three columns with the following names:
1) TE = treatment effect,
2) seTE = the standard error of the treatment effect.
3) design = indicates study type or clustering subgroup.}

\item{mean.mu.0}{Prior mean of the overall mean parameter mu.0 (mean across designs), default value is 0.}

\item{sd.mu.0}{Prior standard deviation of mu.0 (mean across designs), the default value is 10.}

\item{scale.sigma.between}{Prior scale parameter for scale gamma distribution for the
precision between study types. The default value is 0.5.}

\item{df.scale.between}{Degrees of freedom of the scale gamma distribution for the precision between study types.
The default value is 1, which results in a Half Cauchy distribution for the standard
deviation between studies. Larger values e.g. 30 corresponds to a Half Normal distribution.}

\item{scale.sigma.within}{Prior scale parameter for scale gamma distribution for the
precision within study types. The default value is 0.5.}

\item{df.scale.within}{Degrees of freedom of the scale gamma distribution for the precision within study types.
The default value is 1, which results in a Half Cauchy distribution for the standard
deviation between studies. Larger values e.g. 30 corresponds to a Half Normal distribution.}

\item{nr.chains}{Number of chains for the MCMC computations, default 2.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, default is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discard for burn-in period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1.}

\item{be.quiet}{Do not print warning message if the model does not adapt. The default value is FALSE. If you are not sure about the adaptation period choose be.quiet=TRUE.}

\item{r2jags}{Which interface is used to link R to JAGS (rjags and R2jags), default value is R2Jags=TRUE.}
}
\value{
This function returns an object of the class "bmeta". This object contains the MCMC
                           output of each parameter and hyper-parameter in the model and
                           the data frame used for fitting the model.
}
\description{
This function performers a Bayesian meta-analysis
}
\details{
The results of the object of the class bcmeta can be extracted with R2jags or with rjags. In addition a summary, a print and a plot functions are
implemented for this type of object.
}
\examples{
\dontrun{
library(jarbes)


}

}
\references{
Verde, P.E. (2021) A Bias-Corrected Meta-Analysis Model for Combining Studies of Different Types and Quality. Biometrical Journal; 1–17.
}
