% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.bcmeta.R
\name{diagnostic.bcmeta}
\alias{diagnostic.bcmeta}
\title{Diagnostic function for bcmeta object in jarbes}
\usage{
\method{diagnostic}{bcmeta}(
  object,
  post.p.value.cut = 0.05,
  study.names = NULL,
  size.forest = 0.4,
  lwd.forest = 0.2,
  shape.forest = 23,
  bias.plot = TRUE,
  cross.val.plot = TRUE,
  level = c(0.5, 0.75, 0.95),
  x.lim = c(0, 1),
  y.lim = c(0, 10),
  x.lab = "P(Bias)",
  y.lab = "Mean Bias",
  title.plot = paste("Bias Diagnostics Contours (50\%, 75\% and 95\%)"),
  kde2d.n = 25,
  marginals = TRUE,
  bin.hist = 30,
  color.line = "black",
  color.hist = "white",
  color.data.points = "black",
  alpha.data.points = 0.1,
  S = 5000,
  ...
)
}
\arguments{
\item{object}{The object generated by the function b3lmeta.}

\item{post.p.value.cut}{Posterior p-value cut point to assess outliers.}

\item{study.names}{Character vector containing names of the studies used.}

\item{size.forest}{Size of the center symbol mark in the forest-plot lines}

\item{lwd.forest}{Thickness of the lines in the forest-plot}

\item{shape.forest}{Type of symbol for the center mark in the forest-plot lines}

\item{bias.plot}{Display the bias plot. The default is TRUE.}

\item{cross.val.plot}{Display the cross validation plot. The default is TRUE.}

\item{level}{Vector with the probability levels of the contour plot. The default values are: 0.5, 0.75, and 0.95.}

\item{x.lim}{Numeric vector of length 2 specifying the x-axis limits.}

\item{y.lim}{Numeric vector of length 2 specifying the y-axis limits.}

\item{x.lab}{Text with the label of the x-axis.}

\item{y.lab}{Text with the label of the y-axis.}

\item{title.plot}{Text for setting a title in the bias plot.}

\item{kde2d.n}{The number of grid points in each direction for the non-parametric density estimation. The default is 25.}

\item{marginals}{If TRUE the marginal histograms of the posteriors are added to the plot.}

\item{bin.hist}{The number of bins in for the histograms. The default value is 30.}

\item{color.line}{The color of the contour lines. The default is "black.}

\item{color.hist}{The color of the histogram bars. The default is "white".}

\item{color.data.points}{The color of the data points. The default is "black".}

\item{alpha.data.points}{Transparency of the data points.}

\item{S}{The number of sample values from the joint posterior distribution used to approximate the contours. The default is S=5000.}

\item{...}{\dots}
}
\description{
This function performers an approximated Bayesian cross-validation for a bcmeta object and specially designed diagnostics to detect the existence of a biased component.
}
