/*
 * Decompiled with CFR 0.152.
 */
package org.fgilbert.jdx;

import java.math.BigDecimal;
import java.math.BigInteger;

public class TestData {
    public static double getInfinityNegative() {
        return Double.NEGATIVE_INFINITY;
    }

    public static double getInfinityPositive() {
        return Double.POSITIVE_INFINITY;
    }

    public static double getNaN() {
        return Double.NaN;
    }

    public static Object getNull() {
        return null;
    }

    public static boolean getFalse() {
        return false;
    }

    public static boolean getTrue() {
        return true;
    }

    public static boolean getBooleanMin() {
        return false;
    }

    public static boolean getBooleanMax() {
        return true;
    }

    public static byte getByteMin() {
        return -128;
    }

    public static byte getByteMax() {
        return 127;
    }

    public static char getCharacterLow(int codePoint) {
        return Character.toChars(codePoint)[0];
    }

    public static char getCharacterHigh(int codePoint) {
        char[] c = Character.toChars(codePoint);
        if (c.length == 1) {
            return '\u0000';
        }
        return c[1];
    }

    public static char getCharacterMin() {
        return '\u0000';
    }

    public static char getCharacterMax() {
        return '\uffff';
    }

    public static double getDoubleMin() {
        return Double.MIN_NORMAL;
    }

    public static double getDoubleMax() {
        return Double.MAX_VALUE;
    }

    public static float getFloatMin() {
        return Float.MIN_VALUE;
    }

    public static float getFloatMax() {
        return Float.MAX_VALUE;
    }

    public static int getIntMin() {
        return Integer.MIN_VALUE;
    }

    public static int getIntMax() {
        return Integer.MAX_VALUE;
    }

    public static long getLongMin() {
        return Long.MIN_VALUE;
    }

    public static long getLongMax() {
        return Long.MAX_VALUE;
    }

    public static short getShortMin() {
        return Short.MIN_VALUE;
    }

    public static short getShortMax() {
        return Short.MAX_VALUE;
    }

    public static BigDecimal getBigDecimalLarge() {
        BigDecimal v = new BigDecimal(Long.MAX_VALUE);
        return new BigDecimal(v.pow(21).toString());
    }

    public static BigDecimal getBigDecimalSmall() {
        BigDecimal v = new BigDecimal(-9223372036854775807L);
        return new BigDecimal(v.pow(21).toString());
    }

    public static BigDecimal getBigDecimalTen() {
        return BigDecimal.TEN;
    }

    public static BigDecimal getBigDecimalZero() {
        return BigDecimal.ZERO;
    }

    public static BigInteger getBigIntegerLarge() {
        return TestData.getBigDecimalLarge().toBigInteger();
    }

    public static BigInteger getBigIntegerSmall() {
        return TestData.getBigDecimalSmall().toBigInteger();
    }

    public static BigInteger getBigIntegerTen() {
        return BigInteger.TEN;
    }

    public static BigInteger getBigIntegerZero() {
        return BigInteger.ZERO;
    }

    public static Boolean getBoxedBooleanMin() {
        return false;
    }

    public static Boolean getBoxedBooleanMax() {
        return true;
    }

    public static Byte getBoxedByteMin() {
        return (byte)-128;
    }

    public static Byte getBoxedByteMax() {
        return (byte)127;
    }

    public static Character getBoxedCharacterLow(int codePoint) {
        return Character.valueOf(Character.toChars(codePoint)[0]);
    }

    public static Character getBoxedCharacterHigh(int codePoint) {
        char[] c = Character.toChars(codePoint);
        if (c.length == 1) {
            return Character.valueOf('\u0000');
        }
        return Character.valueOf(c[1]);
    }

    public static Character getBoxedCharacterMin() {
        return Character.valueOf('\u0000');
    }

    public static Character getBoxedCharacterMax() {
        return Character.valueOf('\uffff');
    }

    public static Double getBoxedDoubleMin() {
        return Double.MIN_NORMAL;
    }

    public static Double getBoxedDoubleMax() {
        return Double.MAX_VALUE;
    }

    public static Float getBoxedFloatMin() {
        return Float.valueOf(Float.MIN_VALUE);
    }

    public static Float getBoxedFloatMax() {
        return Float.valueOf(Float.MAX_VALUE);
    }

    public static Integer getBoxedIntegerMin() {
        return Integer.MIN_VALUE;
    }

    public static Integer getBoxedIntegerMax() {
        return Integer.MAX_VALUE;
    }

    public static Long getBoxedLongMin() {
        return Long.MIN_VALUE;
    }

    public static Long getBoxedLongMax() {
        return Long.MAX_VALUE;
    }

    public static Short getBoxedShortMin() {
        return (short)Short.MIN_VALUE;
    }

    public static Short getBoxedShortMax() {
        return (short)Short.MAX_VALUE;
    }

    public static String getStringAlphabetLower() {
        return "abcdefghijklmnopqrstuvwxyz";
    }

    public static String getStringEmpty() {
        return "";
    }

    public static boolean[] getBooleanArray1d0x0() {
        return new boolean[0];
    }

    public static boolean[] getBooleanArray1d1x1() {
        return new boolean[]{true};
    }

    public static boolean[] getBooleanArray1d1x2() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        return blArray;
    }

    public static byte[] getByteArray1d0x0() {
        return new byte[0];
    }

    public static byte[] getByteArray1d1x1() {
        return new byte[]{-128};
    }

    public static byte[] getByteArray1dLowZeroHigh() {
        byte[] byArray = new byte[3];
        byArray[0] = -128;
        byArray[2] = 127;
        return byArray;
    }

    public static char[] getCharacterArray1d0x0() {
        return new char[0];
    }

    public static char[] getCharacterArray1d1x1() {
        return new char[]{'1'};
    }

    public static char[] getCharacterArray1d1x3() {
        return new char[]{'1', '2', '3'};
    }

    public static double[] getDoubleArray1d0x0() {
        return new double[0];
    }

    public static double[] getDoubleArray1d1x1() {
        return new double[]{Double.MIN_NORMAL};
    }

    public static double[] getDoubleArray1dLowZeroHigh() {
        return new double[]{Double.MIN_NORMAL, 0.0, Double.MAX_VALUE};
    }

    public static float[] getFloatArray1d0x0() {
        return new float[0];
    }

    public static float[] getFloatArray1d1x1() {
        return new float[]{Float.MIN_VALUE};
    }

    public static float[] getFloatArray1dLowZeroHigh() {
        return new float[]{Float.MIN_VALUE, 0.0f, Float.MAX_VALUE};
    }

    public static int[] getIntArray1d0x0() {
        return new int[0];
    }

    public static int[] getIntArray1d1x1() {
        return new int[]{Integer.MIN_VALUE};
    }

    public static int[] getIntArray1dLowZeroHigh() {
        int[] nArray = new int[3];
        nArray[0] = Integer.MIN_VALUE;
        nArray[2] = Integer.MAX_VALUE;
        return nArray;
    }

    public static long[] getLongArray1d0x0() {
        return new long[0];
    }

    public static long[] getLongArray1d1x1() {
        return new long[]{Long.MIN_VALUE};
    }

    public static long[] getLongArray1dLowZeroHigh() {
        long[] lArray = new long[3];
        lArray[0] = Long.MIN_VALUE;
        lArray[2] = Long.MAX_VALUE;
        return lArray;
    }

    public static short[] getShortArray1d0x0() {
        return new short[0];
    }

    public static short[] getShortArray1d1x1() {
        return new short[]{Short.MIN_VALUE};
    }

    public static short[] getShortArray1dLowZeroHigh() {
        short[] sArray = new short[3];
        sArray[0] = Short.MIN_VALUE;
        sArray[2] = Short.MAX_VALUE;
        return sArray;
    }

    public static BigDecimal[] getBigDecimalArray1d0x0() {
        return new BigDecimal[0];
    }

    public static BigDecimal[] getBigDecimalArray1d1x1() {
        return new BigDecimal[]{new BigDecimal(1)};
    }

    public static BigDecimal[] getBigDecimalArray1d1x2() {
        return new BigDecimal[]{new BigDecimal(Double.MIN_NORMAL), new BigDecimal(Double.MAX_VALUE)};
    }

    public static BigDecimal[] getBigDecimalArray1dNulls() {
        BigDecimal[] bigDecimalArray = new BigDecimal[5];
        bigDecimalArray[1] = new BigDecimal(-1);
        bigDecimalArray[3] = new BigDecimal(1);
        return bigDecimalArray;
    }

    public static BigInteger[] getBigIntegerArray1d0x0() {
        return new BigInteger[0];
    }

    public static BigInteger[] getBigIntegerArray1d1x1() {
        return new BigInteger[]{new BigDecimal(1).toBigInteger()};
    }

    public static BigInteger[] getBigIntegerArray1d1x2() {
        return new BigInteger[]{new BigDecimal(Long.MIN_VALUE).toBigInteger(), new BigDecimal(Long.MAX_VALUE).toBigInteger()};
    }

    public static BigInteger[] getBigIntegerArray1dNulls() {
        BigInteger[] bigIntegerArray = new BigInteger[5];
        bigIntegerArray[1] = new BigDecimal(-1).toBigInteger();
        bigIntegerArray[3] = new BigDecimal(1).toBigInteger();
        return bigIntegerArray;
    }

    public static Boolean[] getBoxedBooleanArray1d0x0() {
        return new Boolean[0];
    }

    public static Boolean[] getBoxedBooleanArray1d1x1() {
        return new Boolean[]{true};
    }

    public static Boolean[] getBoxedBooleanArray1d1x2() {
        return new Boolean[]{false, true};
    }

    public static Boolean[] getBoxedBooleanArray1dNulls() {
        Boolean[] booleanArray = new Boolean[5];
        booleanArray[1] = false;
        booleanArray[3] = true;
        return booleanArray;
    }

    public static Byte[] getBoxedByteArray1d0x0() {
        return new Byte[0];
    }

    public static Byte[] getBoxedByteArray1d1x1() {
        return new Byte[]{(byte)-128};
    }

    public static Byte[] getBoxedByteArray1dLowZeroHigh() {
        return new Byte[]{(byte)-128, (byte)0, (byte)127};
    }

    public static Byte[] getBoxedByteArray1dNulls() {
        Byte[] byteArray = new Byte[5];
        byteArray[1] = -128;
        byteArray[3] = 127;
        return byteArray;
    }

    public static Character[] getBoxedCharacterArray1d0x0() {
        return new Character[0];
    }

    public static Character[] getBoxedCharacterArray1d1x1() {
        return new Character[]{Character.valueOf('1')};
    }

    public static Character[] getBoxedCharacterArray1d1x3() {
        return new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')};
    }

    public static Character[] getBoxedCharacterArray1dNulls() {
        Character[] characterArray = new Character[5];
        characterArray[1] = Character.valueOf('1');
        characterArray[3] = Character.valueOf('3');
        return characterArray;
    }

    public static Double[] getBoxedDoubleArray1d0x0() {
        return new Double[0];
    }

    public static Double[] getBoxedDoubleArray1d1x1() {
        return new Double[]{Double.MIN_NORMAL};
    }

    public static Double[] getBoxedDoubleArray1dLowZeroHigh() {
        return new Double[]{Double.MIN_NORMAL, 0.0, Double.MAX_VALUE};
    }

    public static Double[] getBoxedDoubleArray1dNulls() {
        Double[] doubleArray = new Double[5];
        doubleArray[1] = Double.MIN_NORMAL;
        doubleArray[3] = Double.MAX_VALUE;
        return doubleArray;
    }

    public static Float[] getBoxedFloatArray1d0x0() {
        return new Float[0];
    }

    public static Float[] getBoxedFloatArray1d1x1() {
        return new Float[]{Float.valueOf(Float.MIN_VALUE)};
    }

    public static Float[] getBoxedFloatArray1dLowZeroHigh() {
        return new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)};
    }

    public static Float[] getBoxedFloatArray1dNulls() {
        Float[] floatArray = new Float[5];
        floatArray[1] = Float.valueOf(Float.MIN_VALUE);
        floatArray[3] = Float.valueOf(Float.MAX_VALUE);
        return floatArray;
    }

    public static Integer[] getBoxedIntegerArray1d0x0() {
        return new Integer[0];
    }

    public static Integer[] getBoxedIntegerArray1d1x1() {
        return new Integer[]{Integer.MIN_VALUE};
    }

    public static Integer[] getBoxedIntegerArray1dLowZeroHigh() {
        return new Integer[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
    }

    public static Integer[] getBoxedIntegerArray1dNulls() {
        Integer[] integerArray = new Integer[5];
        integerArray[1] = Integer.MIN_VALUE;
        integerArray[3] = Integer.MAX_VALUE;
        return integerArray;
    }

    public static Long[] getBoxedLongArray1d0x0() {
        return new Long[0];
    }

    public static Long[] getBoxedLongArray1d1x1() {
        return new Long[]{Long.MIN_VALUE};
    }

    public static Long[] getBoxedLongArray1dLowZeroHigh() {
        return new Long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
    }

    public static Long[] getBoxedLongArray1dNulls() {
        Long[] longArray = new Long[5];
        longArray[1] = Long.MIN_VALUE;
        longArray[3] = Long.MAX_VALUE;
        return longArray;
    }

    public static Short[] getBoxedShortArray1d0x0() {
        return new Short[0];
    }

    public static Short[] getBoxedShortArray1d1x1() {
        return new Short[]{(short)Short.MIN_VALUE};
    }

    public static Short[] getBoxedShortArray1dLowZeroHigh() {
        return new Short[]{(short)Short.MIN_VALUE, (short)0, (short)Short.MAX_VALUE};
    }

    public static Short[] getBoxedShortArray1dNulls() {
        Short[] shortArray = new Short[5];
        shortArray[1] = Short.MIN_VALUE;
        shortArray[3] = Short.MAX_VALUE;
        return shortArray;
    }

    public static String[] getStringArray1d0x0() {
        return new String[0];
    }

    public static String[] getStringArray1d1x1() {
        return new String[]{"A"};
    }

    public static String[] getStringArray1dAlphabetLower() {
        return new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    }

    public static String[] getStringArray1dNulls() {
        String[] stringArray = new String[5];
        stringArray[1] = "b";
        stringArray[3] = "d";
        return stringArray;
    }

    public static boolean[][] getBooleanArray2d0x0() {
        return new boolean[0][];
    }

    public static boolean[][] getBooleanArray2d2x0() {
        return new boolean[][]{new boolean[0], new boolean[0]};
    }

    public static boolean[][] getBooleanArray2d2x1() {
        return new boolean[][]{new boolean[1], {true}};
    }

    public static boolean[][] getBooleanArray2d2x2() {
        boolean[][] blArrayArray = new boolean[2][];
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        blArrayArray[1] = blArray2;
        return blArrayArray;
    }

    public static boolean[][] getBooleanArray2dRagged1() {
        boolean[][] blArrayArray = new boolean[6][];
        blArrayArray[0] = new boolean[0];
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        blArrayArray[1] = blArray;
        blArrayArray[2] = new boolean[0];
        blArrayArray[3] = new boolean[1];
        blArrayArray[4] = new boolean[]{true};
        blArrayArray[5] = new boolean[0];
        return blArrayArray;
    }

    public static boolean[][] getBooleanArray2dRagged2() {
        boolean[][] blArrayArray = new boolean[4][];
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        blArrayArray[0] = blArray;
        blArrayArray[1] = new boolean[0];
        blArrayArray[2] = new boolean[1];
        blArrayArray[3] = new boolean[]{true};
        return blArrayArray;
    }

    public static byte[][] getByteArray2d0x0() {
        return new byte[0][];
    }

    public static byte[][] getByteArray2d2x0() {
        return new byte[][]{new byte[0], new byte[0]};
    }

    public static byte[][] getByteArray2d2x1() {
        return new byte[][]{{-128}, {127}};
    }

    public static byte[][] getByteArray2d2x2() {
        byte[][] byArrayArray = new byte[2][];
        byArrayArray[0] = new byte[]{-128, -1};
        byte[] byArray = new byte[2];
        byArray[1] = 127;
        byArrayArray[1] = byArray;
        return byArrayArray;
    }

    public static byte[][] getByteArray2dRagged1() {
        byte[][] byArrayArray = new byte[5][];
        byArrayArray[0] = new byte[0];
        byArrayArray[1] = new byte[]{-128};
        byArrayArray[2] = new byte[0];
        byte[] byArray = new byte[2];
        byArray[1] = 127;
        byArrayArray[3] = byArray;
        byArrayArray[4] = new byte[0];
        return byArrayArray;
    }

    public static byte[][] getByteArray2dRagged2() {
        byte[][] byArrayArray = new byte[3][];
        byArrayArray[0] = new byte[]{-128};
        byArrayArray[1] = new byte[0];
        byte[] byArray = new byte[2];
        byArray[1] = 127;
        byArrayArray[2] = byArray;
        return byArrayArray;
    }

    public static char[][] getCharacterArray2d0x0() {
        return new char[0][];
    }

    public static char[][] getCharacterArray2d2x0() {
        return new char[][]{new char[0], new char[0]};
    }

    public static char[][] getCharacterArray2d2x1() {
        return new char[][]{{'1'}, {'2'}};
    }

    public static char[][] getCharacterArray2d2x2() {
        return new char[][]{{'1', '2'}, {'3', '4'}};
    }

    public static char[][] getCharacterArray2dRagged1() {
        return new char[][]{new char[0], {'1'}, new char[0], {'2', '3'}, new char[0]};
    }

    public static char[][] getCharacterArray2dRagged2() {
        return new char[][]{{'1'}, new char[0], {'2', '3'}};
    }

    public static double[][] getDoubleArray2d0x0() {
        return new double[0][];
    }

    public static double[][] getDoubleArray2d2x0() {
        return new double[][]{new double[0], new double[0]};
    }

    public static double[][] getDoubleArray2d2x1() {
        return new double[][]{{Double.MIN_NORMAL}, {Double.MAX_VALUE}};
    }

    public static double[][] getDoubleArray2d2x2() {
        return new double[][]{{Double.MIN_NORMAL, -1.0}, {0.0, Double.MAX_VALUE}};
    }

    public static double[][] getDoubleArray2dRagged1() {
        return new double[][]{new double[0], {Double.MIN_NORMAL}, new double[0], {0.0, Double.MAX_VALUE}, new double[0]};
    }

    public static double[][] getDoubleArray2dRagged2() {
        return new double[][]{{Double.MIN_NORMAL}, new double[0], {0.0, Double.MAX_VALUE}};
    }

    public static float[][] getFloatArray2d0x0() {
        return new float[0][];
    }

    public static float[][] getFloatArray2d2x0() {
        return new float[][]{new float[0], new float[0]};
    }

    public static float[][] getFloatArray2d2x1() {
        return new float[][]{{Float.MIN_VALUE}, {Float.MAX_VALUE}};
    }

    public static float[][] getFloatArray2d2x2() {
        return new float[][]{{Float.MIN_VALUE, -1.0f}, {0.0f, Float.MAX_VALUE}};
    }

    public static float[][] getFloatArray2dRagged1() {
        return new float[][]{new float[0], {Float.MIN_VALUE}, new float[0], {0.0f, Float.MAX_VALUE}, new float[0]};
    }

    public static float[][] getFloatArray2dRagged2() {
        return new float[][]{{Float.MIN_VALUE}, new float[0], {0.0f, Float.MAX_VALUE}};
    }

    public static int[][] getIntArray2d0x0() {
        return new int[0][];
    }

    public static int[][] getIntArray2d2x0() {
        return new int[][]{new int[0], new int[0]};
    }

    public static int[][] getIntArray2d2x1() {
        return new int[][]{{Integer.MIN_VALUE}, {Integer.MAX_VALUE}};
    }

    public static int[][] getIntArray2d2x2() {
        int[][] nArrayArray = new int[2][];
        nArrayArray[0] = new int[]{Integer.MIN_VALUE, -1};
        int[] nArray = new int[2];
        nArray[1] = Integer.MAX_VALUE;
        nArrayArray[1] = nArray;
        return nArrayArray;
    }

    public static int[][] getIntArray2dRagged1() {
        int[][] nArrayArray = new int[5][];
        nArrayArray[0] = new int[0];
        nArrayArray[1] = new int[]{Integer.MIN_VALUE};
        nArrayArray[2] = new int[0];
        int[] nArray = new int[2];
        nArray[1] = Integer.MAX_VALUE;
        nArrayArray[3] = nArray;
        nArrayArray[4] = new int[0];
        return nArrayArray;
    }

    public static int[][] getIntArray2dRagged2() {
        int[][] nArrayArray = new int[3][];
        nArrayArray[0] = new int[]{Integer.MIN_VALUE};
        nArrayArray[1] = new int[0];
        int[] nArray = new int[2];
        nArray[1] = Integer.MAX_VALUE;
        nArrayArray[2] = nArray;
        return nArrayArray;
    }

    public static long[][] getLongArray2d0x0() {
        return new long[0][];
    }

    public static long[][] getLongArray2d2x0() {
        return new long[][]{new long[0], new long[0]};
    }

    public static long[][] getLongArray2d2x1() {
        return new long[][]{{Long.MIN_VALUE}, {Long.MAX_VALUE}};
    }

    public static long[][] getLongArray2d2x2() {
        long[][] lArrayArray = new long[2][];
        lArrayArray[0] = new long[]{Long.MIN_VALUE, -1L};
        long[] lArray = new long[2];
        lArray[1] = Long.MAX_VALUE;
        lArrayArray[1] = lArray;
        return lArrayArray;
    }

    public static long[][] getLongArray2dRagged1() {
        long[][] lArrayArray = new long[5][];
        lArrayArray[0] = new long[0];
        lArrayArray[1] = new long[]{Long.MIN_VALUE};
        lArrayArray[2] = new long[0];
        long[] lArray = new long[2];
        lArray[1] = Long.MAX_VALUE;
        lArrayArray[3] = lArray;
        lArrayArray[4] = new long[0];
        return lArrayArray;
    }

    public static long[][] getLongArray2dRagged2() {
        long[][] lArrayArray = new long[3][];
        lArrayArray[0] = new long[]{Long.MIN_VALUE};
        lArrayArray[1] = new long[0];
        long[] lArray = new long[2];
        lArray[1] = Long.MAX_VALUE;
        lArrayArray[2] = lArray;
        return lArrayArray;
    }

    public static short[][] getShortArray2d0x0() {
        return new short[0][];
    }

    public static short[][] getShortArray2d2x0() {
        return new short[][]{new short[0], new short[0]};
    }

    public static short[][] getShortArray2d2x1() {
        return new short[][]{{Short.MIN_VALUE}, {Short.MAX_VALUE}};
    }

    public static short[][] getShortArray2d2x2() {
        short[][] sArrayArray = new short[2][];
        sArrayArray[0] = new short[]{Short.MIN_VALUE, -1};
        short[] sArray = new short[2];
        sArray[1] = Short.MAX_VALUE;
        sArrayArray[1] = sArray;
        return sArrayArray;
    }

    public static short[][] getShortArray2dRagged1() {
        short[][] sArrayArray = new short[5][];
        sArrayArray[0] = new short[0];
        sArrayArray[1] = new short[]{Short.MIN_VALUE};
        sArrayArray[2] = new short[0];
        short[] sArray = new short[2];
        sArray[1] = Short.MAX_VALUE;
        sArrayArray[3] = sArray;
        sArrayArray[4] = new short[0];
        return sArrayArray;
    }

    public static short[][] getShortArray2dRagged2() {
        short[][] sArrayArray = new short[3][];
        sArrayArray[0] = new short[]{Short.MIN_VALUE};
        sArrayArray[1] = new short[0];
        short[] sArray = new short[2];
        sArray[1] = Short.MAX_VALUE;
        sArrayArray[2] = sArray;
        return sArrayArray;
    }

    public static BigDecimal[][] getBigDecimalArray2d0x0() {
        return new BigDecimal[0][];
    }

    public static BigDecimal[][] getBigDecimalArray2d2x0() {
        return new BigDecimal[][]{new BigDecimal[0], new BigDecimal[0]};
    }

    public static BigDecimal[][] getBigDecimalArray2d2x1() {
        return new BigDecimal[][]{{new BigDecimal(Double.MIN_NORMAL)}, {new BigDecimal(Double.MAX_VALUE)}};
    }

    public static BigDecimal[][] getBigDecimalArray2d2x2() {
        return new BigDecimal[][]{{BigDecimal.ZERO, BigDecimal.TEN}, {new BigDecimal(Double.MIN_NORMAL), new BigDecimal(Double.MAX_VALUE)}};
    }

    public static BigDecimal[][] getBigDecimalArray2dNulls() {
        BigDecimal[][] bigDecimalArray = new BigDecimal[2][];
        BigDecimal[] bigDecimalArray2 = new BigDecimal[3];
        bigDecimalArray2[1] = BigDecimal.ZERO;
        bigDecimalArray[0] = bigDecimalArray2;
        BigDecimal[] bigDecimalArray3 = new BigDecimal[3];
        bigDecimalArray3[0] = BigDecimal.ONE;
        bigDecimalArray3[2] = BigDecimal.TEN;
        bigDecimalArray[1] = bigDecimalArray3;
        return bigDecimalArray;
    }

    public static BigDecimal[][] getBigDecimalArray2dRagged1() {
        return new BigDecimal[][]{new BigDecimal[0], {BigDecimal.ZERO, BigDecimal.ONE}, new BigDecimal[0], {BigDecimal.TEN}, {BigDecimal.ONE}, new BigDecimal[0]};
    }

    public static BigDecimal[][] getBigDecimalArray2dRagged2() {
        return new BigDecimal[][]{{BigDecimal.ZERO, BigDecimal.ONE}, new BigDecimal[0], {BigDecimal.TEN}, {BigDecimal.ZERO}};
    }

    public static BigInteger[][] getBigIntegerArray2d0x0() {
        return new BigInteger[0][];
    }

    public static BigInteger[][] getBigIntegerArray2d2x0() {
        return new BigInteger[][]{new BigInteger[0], new BigInteger[0]};
    }

    public static BigInteger[][] getBigIntegerArray2d2x1() {
        return new BigInteger[][]{{new BigDecimal(Long.MIN_VALUE).toBigInteger()}, {new BigDecimal(Long.MAX_VALUE).toBigInteger()}};
    }

    public static BigInteger[][] getBigIntegerArray2d2x2() {
        return new BigInteger[][]{{BigInteger.ZERO, BigInteger.TEN}, {new BigDecimal(Long.MIN_VALUE).toBigInteger(), new BigDecimal(Long.MAX_VALUE).toBigInteger()}};
    }

    public static BigInteger[][] getBigIntegerArray2dNulls() {
        BigInteger[][] bigIntegerArray = new BigInteger[2][];
        BigInteger[] bigIntegerArray2 = new BigInteger[3];
        bigIntegerArray2[1] = BigInteger.ZERO;
        bigIntegerArray[0] = bigIntegerArray2;
        BigInteger[] bigIntegerArray3 = new BigInteger[3];
        bigIntegerArray3[0] = BigInteger.ONE;
        bigIntegerArray3[2] = BigInteger.TEN;
        bigIntegerArray[1] = bigIntegerArray3;
        return bigIntegerArray;
    }

    public static BigInteger[][] getBigIntegerArray2dRagged1() {
        return new BigInteger[][]{new BigInteger[0], {BigInteger.ZERO, BigInteger.ONE}, new BigInteger[0], {BigInteger.TEN}, {BigInteger.ONE}, new BigInteger[0]};
    }

    public static BigInteger[][] getBigIntegerArray2dRagged2() {
        return new BigInteger[][]{{BigInteger.ZERO, BigInteger.ONE}, new BigInteger[0], {BigInteger.TEN}, {BigInteger.ZERO}};
    }

    public static Boolean[][] getBoxedBooleanArray2d0x0() {
        return new Boolean[0][];
    }

    public static Boolean[][] getBoxedBooleanArray2d2x0() {
        return new Boolean[][]{new Boolean[0], new Boolean[0]};
    }

    public static Boolean[][] getBoxedBooleanArray2d2x1() {
        return new Boolean[][]{{false}, {true}};
    }

    public static Boolean[][] getBoxedBooleanArray2d2x2() {
        return new Boolean[][]{{false, true}, {true, false}};
    }

    public static Boolean[][] getBoxedBooleanArray2dNulls1() {
        Boolean[][] booleanArray = new Boolean[2][];
        Boolean[] booleanArray2 = new Boolean[3];
        booleanArray2[1] = false;
        booleanArray[0] = booleanArray2;
        Boolean[] booleanArray3 = new Boolean[3];
        booleanArray3[0] = true;
        booleanArray3[2] = true;
        booleanArray[1] = booleanArray3;
        return booleanArray;
    }

    public static Boolean[][] getBoxedBooleanArray2dNulls2() {
        Boolean[][] booleanArray = new Boolean[3][];
        booleanArray[0] = new Boolean[]{false, true};
        Boolean[] booleanArray2 = new Boolean[2];
        booleanArray2[0] = true;
        booleanArray[1] = booleanArray2;
        booleanArray[2] = new Boolean[]{false, true};
        return booleanArray;
    }

    public static Boolean[][] getBoxedBooleanArray2dRagged1() {
        return new Boolean[][]{new Boolean[0], {true, false}, new Boolean[0], {false}, {true}, new Boolean[0]};
    }

    public static Boolean[][] getBoxedBooleanArray2dRagged2() {
        return new Boolean[][]{{true, false}, new Boolean[0], {false}, {true}};
    }

    public static Byte[][] getBoxedByteArray2d0x0() {
        return new Byte[0][];
    }

    public static Byte[][] getBoxedByteArray2d2x0() {
        return new Byte[][]{new Byte[0], new Byte[0]};
    }

    public static Byte[][] getBoxedByteArray2d2x1() {
        return new Byte[][]{{(byte)-128}, {(byte)127}};
    }

    public static Byte[][] getBoxedByteArray2d2x2() {
        return new Byte[][]{{(byte)-128, (byte)-1}, {(byte)0, (byte)127}};
    }

    public static Byte[][] getBoxedByteArray2dNulls1() {
        Byte[][] byteArray = new Byte[2][];
        Byte[] byteArray2 = new Byte[3];
        byteArray2[1] = -128;
        byteArray[0] = byteArray2;
        Byte[] byteArray3 = new Byte[3];
        byteArray3[0] = -128;
        byteArray3[2] = 127;
        byteArray[1] = byteArray3;
        return byteArray;
    }

    public static Byte[][] getBoxedByteArray2dNulls2() {
        Byte[][] byteArray = new Byte[3][];
        byteArray[0] = new Byte[]{(byte)-128, (byte)127};
        Byte[] byteArray2 = new Byte[2];
        byteArray2[0] = -128;
        byteArray[1] = byteArray2;
        byteArray[2] = new Byte[]{(byte)-128, (byte)127};
        return byteArray;
    }

    public static Byte[][] getBoxedByteArray2dRagged1() {
        return new Byte[][]{new Byte[0], {(byte)-128}, new Byte[0], {(byte)0, (byte)127}, new Byte[0]};
    }

    public static Byte[][] getBoxedByteArray2dRagged2() {
        return new Byte[][]{{(byte)-128}, new Byte[0], {(byte)0, (byte)127}};
    }

    public static Character[][] getBoxedCharacterArray2d0x0() {
        return new Character[0][];
    }

    public static Character[][] getBoxedCharacterArray2d2x0() {
        return new Character[][]{new Character[0], new Character[0]};
    }

    public static Character[][] getBoxedCharacterArray2d2x1() {
        return new Character[][]{{Character.valueOf('1')}, {Character.valueOf('2')}};
    }

    public static Character[][] getBoxedCharacterArray2d2x2() {
        return new Character[][]{{Character.valueOf('1'), Character.valueOf('2')}, {Character.valueOf('3'), Character.valueOf('4')}};
    }

    public static Character[][] getBoxedCharacterArray2dNulls() {
        Character[][] characterArray = new Character[2][];
        Character[] characterArray2 = new Character[3];
        characterArray2[1] = Character.valueOf('1');
        characterArray[0] = characterArray2;
        Character[] characterArray3 = new Character[3];
        characterArray3[0] = Character.valueOf('2');
        characterArray3[2] = Character.valueOf('3');
        characterArray[1] = characterArray3;
        return characterArray;
    }

    public static Character[][] getBoxedCharacterArray2dRagged1() {
        return new Character[][]{new Character[0], {Character.valueOf('1')}, new Character[0], {Character.valueOf('2'), Character.valueOf('3')}, new Character[0]};
    }

    public static Character[][] getBoxedCharacterArray2dRagged2() {
        return new Character[][]{{Character.valueOf('1')}, new Character[0], {Character.valueOf('2'), Character.valueOf('3')}};
    }

    public static Double[][] getBoxedDoubleArray2d0x0() {
        return new Double[0][];
    }

    public static Double[][] getBoxedDoubleArray2d2x0() {
        return new Double[][]{new Double[0], new Double[0]};
    }

    public static Double[][] getBoxedDoubleArray2d2x1() {
        return new Double[][]{{Double.MIN_NORMAL}, {Double.MAX_VALUE}};
    }

    public static Double[][] getBoxedDoubleArray2d2x2() {
        return new Double[][]{{Double.MIN_NORMAL, -1.0}, {0.0, Double.MAX_VALUE}};
    }

    public static Double[][] getBoxedDoubleArray2dNulls() {
        Double[][] doubleArray = new Double[2][];
        Double[] doubleArray2 = new Double[3];
        doubleArray2[1] = Double.MIN_NORMAL;
        doubleArray[0] = doubleArray2;
        Double[] doubleArray3 = new Double[3];
        doubleArray3[0] = Double.MIN_NORMAL;
        doubleArray3[2] = Double.MAX_VALUE;
        doubleArray[1] = doubleArray3;
        return doubleArray;
    }

    public static Double[][] getBoxedDoubleArray2dRagged1() {
        return new Double[][]{new Double[0], {Double.MIN_NORMAL}, new Double[0], {0.0, Double.MAX_VALUE}, new Double[0]};
    }

    public static Double[][] getBoxedDoubleArray2dRagged2() {
        return new Double[][]{{Double.MIN_NORMAL}, new Double[0], {0.0, Double.MAX_VALUE}};
    }

    public static Float[][] getBoxedFloatArray2d0x0() {
        return new Float[0][];
    }

    public static Float[][] getBoxedFloatArray2d2x0() {
        return new Float[][]{new Float[0], new Float[0]};
    }

    public static Float[][] getBoxedFloatArray2d2x1() {
        return new Float[][]{{Float.valueOf(Float.MIN_VALUE)}, {Float.valueOf(Float.MAX_VALUE)}};
    }

    public static Float[][] getBoxedFloatArray2d2x2() {
        return new Float[][]{{Float.valueOf(Float.MIN_VALUE), Float.valueOf(-1.0f)}, {Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)}};
    }

    public static Float[][] getBoxedFloatArray2dNulls() {
        Float[][] floatArray = new Float[2][];
        Float[] floatArray2 = new Float[3];
        floatArray2[1] = Float.valueOf(Float.MIN_VALUE);
        floatArray[0] = floatArray2;
        Float[] floatArray3 = new Float[3];
        floatArray3[0] = Float.valueOf(Float.MIN_VALUE);
        floatArray3[2] = Float.valueOf(Float.MAX_VALUE);
        floatArray[1] = floatArray3;
        return floatArray;
    }

    public static Float[][] getBoxedFloatArray2dRagged1() {
        return new Float[][]{new Float[0], {Float.valueOf(Float.MIN_VALUE)}, new Float[0], {Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)}, new Float[0]};
    }

    public static Float[][] getBoxedFloatArray2dRagged2() {
        return new Float[][]{{Float.valueOf(Float.MIN_VALUE)}, new Float[0], {Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)}};
    }

    public static Integer[][] getBoxedIntegerArray2d0x0() {
        return new Integer[0][];
    }

    public static Integer[][] getBoxedIntegerArray2d2x0() {
        return new Integer[][]{new Integer[0], new Integer[0]};
    }

    public static Integer[][] getBoxedIntegerArray2d2x1() {
        return new Integer[][]{{Integer.MIN_VALUE}, {Integer.MAX_VALUE}};
    }

    public static Integer[][] getBoxedIntegerArray2d2x2() {
        return new Integer[][]{{Integer.MIN_VALUE, -1}, {0, Integer.MAX_VALUE}};
    }

    public static Integer[][] getBoxedIntegerArray2dNulls() {
        Integer[][] integerArray = new Integer[2][];
        Integer[] integerArray2 = new Integer[3];
        integerArray2[1] = Integer.MIN_VALUE;
        integerArray[0] = integerArray2;
        Integer[] integerArray3 = new Integer[3];
        integerArray3[0] = Integer.MIN_VALUE;
        integerArray3[2] = Integer.MAX_VALUE;
        integerArray[1] = integerArray3;
        return integerArray;
    }

    public static Integer[][] getBoxedIntegerArray2dRagged1() {
        return new Integer[][]{new Integer[0], {Integer.MIN_VALUE}, new Integer[0], {0, Integer.MAX_VALUE}, new Integer[0]};
    }

    public static Integer[][] getBoxedIntegerArray2dRagged2() {
        return new Integer[][]{{Integer.MIN_VALUE}, new Integer[0], {0, Integer.MAX_VALUE}};
    }

    public static Long[][] getBoxedLongArray2d0x0() {
        return new Long[0][];
    }

    public static Long[][] getBoxedLongArray2d2x0() {
        return new Long[][]{new Long[0], new Long[0]};
    }

    public static Long[][] getBoxedLongArray2d2x1() {
        return new Long[][]{{Long.MIN_VALUE}, {Long.MAX_VALUE}};
    }

    public static Long[][] getBoxedLongArray2d2x2() {
        return new Long[][]{{Long.MIN_VALUE, -1L}, {0L, Long.MAX_VALUE}};
    }

    public static Long[][] getBoxedLongArray2dNulls() {
        Long[][] longArray = new Long[2][];
        Long[] longArray2 = new Long[3];
        longArray2[1] = Long.MIN_VALUE;
        longArray[0] = longArray2;
        Long[] longArray3 = new Long[3];
        longArray3[0] = Long.MIN_VALUE;
        longArray3[2] = Long.MAX_VALUE;
        longArray[1] = longArray3;
        return longArray;
    }

    public static Long[][] getBoxedLongArray2dRagged1() {
        return new Long[][]{new Long[0], {Long.MIN_VALUE}, new Long[0], {0L, Long.MAX_VALUE}, new Long[0]};
    }

    public static Long[][] getBoxedLongArray2dRagged2() {
        return new Long[][]{{Long.MIN_VALUE}, new Long[0], {0L, Long.MAX_VALUE}};
    }

    public static Short[][] getBoxedShortArray2d0x0() {
        return new Short[0][];
    }

    public static Short[][] getBoxedShortArray2d2x0() {
        return new Short[][]{new Short[0], new Short[0]};
    }

    public static Short[][] getBoxedShortArray2d2x1() {
        return new Short[][]{{(short)Short.MIN_VALUE}, {(short)Short.MAX_VALUE}};
    }

    public static Short[][] getBoxedShortArray2d2x2() {
        return new Short[][]{{(short)Short.MIN_VALUE, (short)-1}, {(short)0, (short)Short.MAX_VALUE}};
    }

    public static Short[][] getBoxedShortArray2dNulls() {
        Short[][] shortArray = new Short[2][];
        Short[] shortArray2 = new Short[3];
        shortArray2[1] = Short.MIN_VALUE;
        shortArray[0] = shortArray2;
        Short[] shortArray3 = new Short[3];
        shortArray3[0] = Short.MIN_VALUE;
        shortArray3[2] = Short.MAX_VALUE;
        shortArray[1] = shortArray3;
        return shortArray;
    }

    public static Short[][] getBoxedShortArray2dRagged1() {
        return new Short[][]{new Short[0], {(short)Short.MIN_VALUE}, new Short[0], {(short)0, (short)Short.MAX_VALUE}, new Short[0]};
    }

    public static Short[][] getBoxedShortArray2dRagged2() {
        return new Short[][]{{(short)Short.MIN_VALUE}, new Short[0], {(short)0, (short)Short.MAX_VALUE}};
    }

    public static String[][] getStringArray2d0x0() {
        return new String[0][];
    }

    public static String[][] getStringArray2d2x0() {
        return new String[][]{new String[0], new String[0]};
    }

    public static String[][] getStringArray2d2x1() {
        return new String[][]{{""}, {""}};
    }

    public static String[][] getStringArray2d2x2() {
        return new String[][]{{"", " "}, {"a", "Z"}};
    }

    public static String[][] getStringArray2dNulls() {
        String[][] stringArray = new String[2][];
        String[] stringArray2 = new String[3];
        stringArray2[1] = "";
        stringArray[0] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = "a";
        stringArray3[2] = "Z";
        stringArray[1] = stringArray3;
        return stringArray;
    }

    public static String[][] getStringArray2dRagged1() {
        return new String[][]{new String[0], {""}, new String[0], {"a", "Z"}, new String[0]};
    }

    public static String[][] getStringArray2dRagged2() {
        return new String[][]{{""}, new String[0], {"a", "Z"}};
    }

    public static Boolean[][][] getBoxedBooleanArray3dNulls() {
        Boolean[][][] booleanArray = new Boolean[2][][];
        Boolean[][] booleanArrayArray = new Boolean[3][];
        booleanArrayArray[0] = new Boolean[]{false, true};
        Boolean[] booleanArray2 = new Boolean[2];
        booleanArray2[0] = true;
        booleanArrayArray[1] = booleanArray2;
        booleanArrayArray[2] = new Boolean[]{false, true};
        booleanArray[0] = booleanArrayArray;
        booleanArray[1] = new Boolean[][]{{false, true}, {true, true}, {false, true}};
        return booleanArray;
    }

    public static Boolean[][][] getBoxedBooleanArray3dRagged() {
        return new Boolean[][][]{{{true, false}, new Boolean[0], {false}, {true}}, {{true, false}, {true}, {false}, {true}}};
    }

    public static Byte[][][] getBoxedByteArray3dNulls() {
        Byte[][][] byteArray = new Byte[2][][];
        Byte[][] byteArrayArray = new Byte[3][];
        byteArrayArray[0] = new Byte[]{(byte)-128, (byte)127};
        Byte[] byteArray2 = new Byte[2];
        byteArray2[0] = -128;
        byteArrayArray[1] = byteArray2;
        byteArrayArray[2] = new Byte[]{(byte)-128, (byte)127};
        byteArray[0] = byteArrayArray;
        byteArray[1] = new Byte[][]{{(byte)-128, (byte)127}, {(byte)-128, (byte)-128}, {(byte)-128, (byte)127}};
        return byteArray;
    }

    public static Byte[][][] getBoxedByteArray3dRagged() {
        return new Byte[][][]{{{(byte)-128}, new Byte[0], {(byte)0, (byte)127}}, {{(byte)-128}, {(byte)1}, {(byte)0, (byte)127}}};
    }
}

