% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoLegend.R
\name{annoLegend}
\alias{annoLegend}
\title{annoLegend}
\usage{
annoLegend(
  object = NULL,
  relPos = c(0.9, 0.9),
  xPosition = NULL,
  yPosition = NULL,
  labels = NULL,
  vgap = 1,
  hgap = 1,
  cex = 1,
  pch = NULL,
  ncol = 1,
  col = NULL,
  fill = NULL,
  do.lines = FALSE,
  lines.first = FALSE,
  textSize = NULL,
  fontfamily = NULL,
  fontface = NULL
)
}
\arguments{
\item{object}{This function is used to add segment annotations in plot.}

\item{relPos}{The relative position of legend.  Default(c(0.9,0.9)).}

\item{xPosition}{The x axis coordinate for the legend. Default(NULL).}

\item{yPosition}{The x axis coordinate for the legend. Default(NULL).}

\item{labels}{The legend text labels. Default(NULL).}

\item{vgap}{Vertical space between the legend entries. Default(1).}

\item{hgap}{Horizontal space between the legend entries. Default(1).}

\item{cex}{The legend key size. Default(1).}

\item{pch}{Legend shape. Default(NULL).}

\item{ncol}{Legend columns to show. Default(NULL).}

\item{col}{Legend colors. Default(NULL).}

\item{fill}{Legend fill colors. Default(NULL).}

\item{do.lines}{Whether to show lines. Default(FALSE).}

\item{lines.first}{Whether to show lines first. Default(FALSE).}

\item{textSize}{Legend text size. Default(NULL).}

\item{fontfamily}{Legend text fontfamily. Default(NULL).}

\item{fontface}{Legend text fontface. Default(NULL).}
}
\value{
Return a ggplot object.
}
\description{
This function is used to add legend annotations in plot.
}
\examples{
# ===============================
# test function

# load data
data(p)

# add legend
annoLegend(object = p,
           labels = paste('legend ',1:5),
           pch = 21,
           col = 'black',
           fill = useMyCol('paired',5),
           textSize = 15)

# change pos
annoLegend(object = p,
           relPos = c(0.2,0.9),
           labels = paste('legend ',1:5),
           pch = 21,
           col = 'black',
           fill = useMyCol('paired',5),
           textSize = 15)
}
\author{
Junjun Lao
}
