% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_station.R
\name{nearest_station}
\alias{nearest_station}
\alias{pick_neighbor_stations}
\alias{pick_neighbor_tide_stations}
\title{Find out neighborhood stations}
\usage{
nearest_station(longitude, latitude, geometry = NULL)

pick_neighbor_stations(
  longitude,
  latitude,
  distance = 1,
  .unit = "m",
  geometry = NULL
)

pick_neighbor_tide_stations(
  year,
  longitude,
  latitude,
  distance = 100,
  .unit = "km",
  geometry = NULL
)
}
\arguments{
\item{longitude}{Longitude.}

\item{latitude}{Latitude.}

\item{geometry}{XY \link[sf:sf]{sf::sf} object.}

\item{distance}{Distance from station to station to adjustment.}

\item{.unit}{Unit used for extraction from the point of interest. Default \emph{m} (meters).
This value is passed to \link[units:units]{units::as_units}.}

\item{year}{For tide level data. Restricted to the observation points in the target year.}
}
\value{
an object of class \code{sf}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Return the nearest \link{stations} information to the given coordinates.
}
\details{
\itemize{
\item \code{nearest_station()}: Return single station data.
\item \code{pick_neighbor_stations()}: Pick-up neighbourhood stations.
\item \code{pick_neighbor_tide_stations()}: Pick-up neighbourhood tidal observation stations.
Filter by distance from target point.
}
}
\examples{
nearest_station(142.9313, 43.70417)

pick_neighbor_stations(140.10, 36.08, 300000)

d <-
  pick_neighbor_stations(140.10, 36.08, 30, "km")
pick_neighbor_stations(geometry = sf::st_point(c(140.1833, 36.23333)),
                       distance = 100)

pick_neighbor_tide_stations(longitude = 133.4375, latitude = 34.45833,
                            year = 2020,
                            distance = 100, .unit = "km")
}
