
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
anovaOptions <- R6::R6Class(
    "anovaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            dependent = NULL,
            fixedFactors = NULL,
            modelTerms = NULL,
            contrasts = NULL,
            descPlotsHAxis = NULL,
            descPlotsSepLines = NULL,
            descPlotsSepPlots = NULL,
            postHoc = NULL,
            corrNone = FALSE,
            corrTukey = TRUE,
            corrScheffe = FALSE,
            corrBonf = FALSE,
            corrHolm = FALSE,
            descStats = FALSE,
            homo = FALSE,
            qq = FALSE,
            etaSq = FALSE,
            etaSqP = FALSE,
            omegaSq = FALSE,
            plotError = "ci",
            ciWidth = 95,
            ss = "3", ...) {

            super$initialize(
                package='jmv',
                name='anova',
                requiresData=TRUE,
                ...)
        
            private$..dependent <- jmvcore::OptionVariable$new(
                "dependent",
                dependent,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..fixedFactors <- jmvcore::OptionVariables$new(
                "fixedFactors",
                fixedFactors,
                suggested=list(
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..modelTerms <- jmvcore::OptionTerms$new(
                "modelTerms",
                modelTerms,
                default=NULL)
            private$..contrasts <- jmvcore::OptionArray$new(
                "contrasts",
                contrasts,
                items="(fixedFactors)",
                default=NULL,
                template=jmvcore::OptionGroup$new(
                    "contrasts",
                    NULL,
                    elements=list(
                        jmvcore::OptionVariable$new(
                            "var",
                            NULL,
                            content="$key"),
                        jmvcore::OptionList$new(
                            "type",
                            NULL,
                            options=list(
                                "none",
                                "deviation",
                                "simple",
                                "difference",
                                "helmert",
                                "repeated",
                                "polynomial")))))
            private$..descPlotsHAxis <- jmvcore::OptionVariable$new(
                "descPlotsHAxis",
                descPlotsHAxis,
                default=NULL)
            private$..descPlotsSepLines <- jmvcore::OptionVariable$new(
                "descPlotsSepLines",
                descPlotsSepLines,
                default=NULL)
            private$..descPlotsSepPlots <- jmvcore::OptionVariable$new(
                "descPlotsSepPlots",
                descPlotsSepPlots,
                default=NULL)
            private$..postHoc <- jmvcore::OptionTerms$new(
                "postHoc",
                postHoc,
                default=NULL)
            private$..corrNone <- jmvcore::OptionBool$new(
                "corrNone",
                corrNone,
                default=FALSE)
            private$..corrTukey <- jmvcore::OptionBool$new(
                "corrTukey",
                corrTukey,
                default=TRUE)
            private$..corrScheffe <- jmvcore::OptionBool$new(
                "corrScheffe",
                corrScheffe,
                default=FALSE)
            private$..corrBonf <- jmvcore::OptionBool$new(
                "corrBonf",
                corrBonf,
                default=FALSE)
            private$..corrHolm <- jmvcore::OptionBool$new(
                "corrHolm",
                corrHolm,
                default=FALSE)
            private$..descStats <- jmvcore::OptionBool$new(
                "descStats",
                descStats,
                default=FALSE)
            private$..homo <- jmvcore::OptionBool$new(
                "homo",
                homo,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..etaSq <- jmvcore::OptionBool$new(
                "etaSq",
                etaSq,
                default=FALSE)
            private$..etaSqP <- jmvcore::OptionBool$new(
                "etaSqP",
                etaSqP,
                default=FALSE)
            private$..omegaSq <- jmvcore::OptionBool$new(
                "omegaSq",
                omegaSq,
                default=FALSE)
            private$..plotError <- jmvcore::OptionList$new(
                "plotError",
                plotError,
                options=list(
                    "ci",
                    "se"),
                default="ci")
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..ss <- jmvcore::OptionList$new(
                "ss",
                ss,
                options=list(
                    "1",
                    "2",
                    "3"),
                default="3")
        
            self$.addOption(private$..dependent)
            self$.addOption(private$..fixedFactors)
            self$.addOption(private$..modelTerms)
            self$.addOption(private$..contrasts)
            self$.addOption(private$..descPlotsHAxis)
            self$.addOption(private$..descPlotsSepLines)
            self$.addOption(private$..descPlotsSepPlots)
            self$.addOption(private$..postHoc)
            self$.addOption(private$..corrNone)
            self$.addOption(private$..corrTukey)
            self$.addOption(private$..corrScheffe)
            self$.addOption(private$..corrBonf)
            self$.addOption(private$..corrHolm)
            self$.addOption(private$..descStats)
            self$.addOption(private$..homo)
            self$.addOption(private$..qq)
            self$.addOption(private$..etaSq)
            self$.addOption(private$..etaSqP)
            self$.addOption(private$..omegaSq)
            self$.addOption(private$..plotError)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..ss)
        }),
    active = list(
        dependent = function() private$..dependent$value,
        fixedFactors = function() private$..fixedFactors$value,
        modelTerms = function() private$..modelTerms$value,
        contrasts = function() private$..contrasts$value,
        descPlotsHAxis = function() private$..descPlotsHAxis$value,
        descPlotsSepLines = function() private$..descPlotsSepLines$value,
        descPlotsSepPlots = function() private$..descPlotsSepPlots$value,
        postHoc = function() private$..postHoc$value,
        corrNone = function() private$..corrNone$value,
        corrTukey = function() private$..corrTukey$value,
        corrScheffe = function() private$..corrScheffe$value,
        corrBonf = function() private$..corrBonf$value,
        corrHolm = function() private$..corrHolm$value,
        descStats = function() private$..descStats$value,
        homo = function() private$..homo$value,
        qq = function() private$..qq$value,
        etaSq = function() private$..etaSq$value,
        etaSqP = function() private$..etaSqP$value,
        omegaSq = function() private$..omegaSq$value,
        plotError = function() private$..plotError$value,
        ciWidth = function() private$..ciWidth$value,
        ss = function() private$..ss$value),
    private = list(
        ..dependent = NA,
        ..fixedFactors = NA,
        ..modelTerms = NA,
        ..contrasts = NA,
        ..descPlotsHAxis = NA,
        ..descPlotsSepLines = NA,
        ..descPlotsSepPlots = NA,
        ..postHoc = NA,
        ..corrNone = NA,
        ..corrTukey = NA,
        ..corrScheffe = NA,
        ..corrBonf = NA,
        ..corrHolm = NA,
        ..descStats = NA,
        ..homo = NA,
        ..qq = NA,
        ..etaSq = NA,
        ..etaSqP = NA,
        ..omegaSq = NA,
        ..plotError = NA,
        ..ciWidth = NA,
        ..ss = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
anovaResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        main = function() private$..main,
        assump = function() private$..assump,
        contrasts = function() private$..contrasts,
        postHoc = function() private$..postHoc,
        desc = function() private$..desc,
        plots = function() private$..plots),
    private = list(
        ..main = NA,
        ..assump = NA,
        ..contrasts = NA,
        ..postHoc = NA,
        ..desc = NA,
        ..plots = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="ANOVA")
            private$..main <- jmvcore::Table$new(
                options=options,
                name="main",
                title="ANOVA",
                clearWith=list(
                    "dependent",
                    "modelTerms",
                    "ss"),
                columns=list(
                    list(`name`="name", `title`="", `type`="text"),
                    list(`name`="ss", `title`="Sum of Squares", `type`="number"),
                    list(`name`="df", `title`="df", `type`="integer"),
                    list(`name`="ms", `title`="Mean Square", `type`="number"),
                    list(`name`="F", `title`="F", `type`="number"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="etaSq", `title`="\u03B7\u00B2", `type`="number", `visible`="(etaSq)", `format`="zto"),
                    list(`name`="etaSqP", `title`="\u03B7\u00B2p", `type`="number", `visible`="(etaSqP)", `format`="zto"),
                    list(`name`="omegaSq", `title`="\u03C9\u00B2", `type`="number", `visible`="(omegaSq)", `format`="zto")))
            private$..assump <- R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    homo = function() private$..homo,
                    qq = function() private$..qq),
                private = list(
                    ..homo = NA,
                    ..qq = NA),
                public=list(
                    initialize=function(options) {
                        super$initialize(options=options, name="assump", title="Assumption Checks")
                        private$..homo <- jmvcore::Table$new(
                            options=options,
                            name="homo",
                            title="Test for Homogeneity of Variances (Levene's)",
                            visible="(homo)",
                            rows=1,
                            columns=list(
                                list(`name`="F", `type`="number"),
                                list(`name`="df1", `type`="integer"),
                                list(`name`="df2", `type`="integer"),
                                list(`name`="p", `type`="number", `format`="zto,pvalue")))
                        private$..qq <- jmvcore::Image$new(
                            options=options,
                            name="qq",
                            title="Q-Q Plot",
                            visible="(qq)",
                            width=300,
                            height=300,
                            renderFun=".qqPlot",
                            clearWith=list(
                                "dependent",
                                "modelTerms"))
                        self$add(private$..homo)
                        self$add(private$..qq)}))$new(options=options)
            private$..contrasts <- jmvcore::Array$new(
                options=options,
                name="contrasts",
                title="Contrasts",
                visible="(contrasts)",
                clearWith=list(
                    "dependent",
                    "modelTerms"),
                template=jmvcore::Table$new(
                    options=options,
                    title="Contrasts - $key",
                    clearWith=NULL,
                    columns=list(
                        list(`name`="contrast", `title`="", `type`="text"),
                        list(`name`="est", `title`="Estimate", `type`="number"),
                        list(`name`="se", `title`="SE", `type`="number"),
                        list(`name`="t", `type`="number"),
                        list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue"))))
            private$..postHoc <- jmvcore::Array$new(
                options=options,
                name="postHoc",
                title="Post Hoc Tests",
                items="(postHoc)",
                clearWith=list(
                    "dependent",
                    "modelTerms"),
                template=jmvcore::Table$new(
                    options=options,
                    title="Post Hoc Comparisons - $key",
                    clearWith=NULL,
                    columns=list(
                        list(`name`="var1", `title`="", `type`="text", `combineBelow`=TRUE),
                        list(`name`="var2", `title`="", `type`="text"),
                        list(`name`="md", `title`="Mean Difference", `type`="number"),
                        list(`name`="se", `title`="SE", `type`="number"),
                        list(`name`="t", `title`="t", `type`="number"),
                        list(`name`="p", `title`="p", `visible`="(corrNone)", `type`="number", `format`="zto,pvalue"),
                        list(`name`="ptukey", `title`="p<sub>tukey</sub>", `visible`="(corrTukey)", `type`="number", `format`="zto,pvalue"),
                        list(`name`="pscheffe", `title`="p<sub>scheffe</sub>", `visible`="(corrScheffe)", `type`="number", `format`="zto,pvalue"),
                        list(`name`="pbonf", `title`="p<sub>bonferoni</sub>", `visible`="(corrBonf)", `type`="number", `format`="zto,pvalue"),
                        list(`name`="pholm", `title`="p<sub>holm</sub>", `visible`="(corrHolm)", `type`="number", `format`="zto,pvalue"))))
            private$..desc <- jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(descStats)",
                clearWith=list(
                    "dependent",
                    "modelTerms",
                    "ss"),
                columns=list(
                    list(`name`="n", `title`="N", `type`="integer"),
                    list(`name`="mean", `title`="Mean", `type`="text"),
                    list(`name`="sd", `title`="SD", `type`="number")))
            private$..plots <- jmvcore::Image$new(
                options=options,
                name="plots",
                title="Plots",
                visible="(descPlotsHAxis)",
                width=500,
                height=300,
                renderFun=".descPlot",
                clearWith=list(
                    "dependent",
                    "fixedFactors",
                    "descPlotsHAxis",
                    "descPlotsSepLines",
                    "descPlotsSepPlots",
                    "plotError",
                    "ciWidth"))
            self$add(private$..main)
            self$add(private$..assump)
            self$add(private$..contrasts)
            self$add(private$..postHoc)
            self$add(private$..desc)
            self$add(private$..plots)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
anovaBase <- R6::R6Class(
    "anovaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'anova',
                version = c(1,0,0),
                options = options,
                results = anovaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL)
        }))

#' ANOVA
#'
#' Analysis of Variance
#' @param data the data as a data frame
#' @param dependent a string naming the dependent variable from \code{data}, 
#'   variable must be numeric 
#' @param fixedFactors a vector of strings naming the fixed factors from 
#'   \code{data}
#' @param modelTerms a list of character vectors describing the terms to go 
#'   into the model 
#' @param contrasts contrasts
#' @param descPlotsHAxis a string naming the variable placed on the horizontal 
#'   axis of the plot 
#' @param descPlotsSepLines a string naming the variable represented as 
#'   separate lines on the plot 
#' @param descPlotsSepPlots a string naming the variable to separate over to 
#'   form multiple plots 
#' @param postHoc a list of terms to perform post-hoc tests on
#' @param corrNone \code{TRUE} or \code{FALSE} (default), provide uncorrected 
#'   p-values in post-hoc tests 
#' @param corrTukey \code{TRUE} (default) or \code{FALSE}, perform Tukey 
#'   correction in post-hoc tests 
#' @param corrScheffe \code{TRUE} or \code{FALSE} (default), perform Scheffe 
#'   correction in post-hoc tests 
#' @param corrBonf \code{TRUE} or \code{FALSE} (default), perform Bonferroni 
#'   correction in post-hoc tests 
#' @param corrHolm \code{TRUE} or \code{FALSE} (default), perform Holm 
#'   correction in post-hoc tests 
#' @param descStats \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   statistics 
#' @param homo \code{TRUE} or \code{FALSE} (default), perform homogeneity 
#'   tests 
#' @param qq \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of 
#'   residuals 
#' @param etaSq \code{TRUE} or \code{FALSE} (default), provide eta² (effect 
#'   size) 
#' @param etaSqP \code{TRUE} or \code{FALSE} (default), provide partial eta² 
#'   (effect size) 
#' @param omegaSq \code{TRUE} or \code{FALSE} (default), provide omega² 
#'   (effect size) 
#' @param plotError \code{'ci'} or \code{'se'}, use confidence intervals or 
#'   standard errors on the plot 
#' @param ciWidth a number between 50 and 99.9 (default: 95) specifying the 
#'   confidence interval width 
#' @param ss \code{'1'}, \code{'2'} or \code{'3'} (default), the sum of 
#'   squares to use 
#' @export
anova <- function(
    data,
    dependent,
    fixedFactors = NULL,
    modelTerms = NULL,
    contrasts = NULL,
    descPlotsHAxis = NULL,
    descPlotsSepLines = NULL,
    descPlotsSepPlots = NULL,
    postHoc = NULL,
    corrNone = FALSE,
    corrTukey = TRUE,
    corrScheffe = FALSE,
    corrBonf = FALSE,
    corrHolm = FALSE,
    descStats = FALSE,
    homo = FALSE,
    qq = FALSE,
    etaSq = FALSE,
    etaSqP = FALSE,
    omegaSq = FALSE,
    plotError = "ci",
    ciWidth = 95,
    ss = "3") {

    options <- anovaOptions$new(
        dependent = dependent,
        fixedFactors = fixedFactors,
        modelTerms = modelTerms,
        contrasts = contrasts,
        descPlotsHAxis = descPlotsHAxis,
        descPlotsSepLines = descPlotsSepLines,
        descPlotsSepPlots = descPlotsSepPlots,
        postHoc = postHoc,
        corrNone = corrNone,
        corrTukey = corrTukey,
        corrScheffe = corrScheffe,
        corrBonf = corrBonf,
        corrHolm = corrHolm,
        descStats = descStats,
        homo = homo,
        qq = qq,
        etaSq = etaSq,
        etaSqP = etaSqP,
        omegaSq = omegaSq,
        plotError = plotError,
        ciWidth = ciWidth,
        ss = ss)

    results <- anovaResults$new(
        options = options)

    analysis <- anovaClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis
}
