% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.h.R
\name{anova}
\alias{anova}
\title{ANOVA}
\usage{
anova(data, dependent, fixedFactors = NULL, modelTerms = NULL,
  contrasts = NULL, descPlotsHAxis = NULL, descPlotsSepLines = NULL,
  descPlotsSepPlots = NULL, postHoc = NULL, corrNone = FALSE,
  corrTukey = TRUE, corrScheffe = FALSE, corrBonf = FALSE,
  corrHolm = FALSE, descStats = FALSE, homo = FALSE, qq = FALSE,
  etaSq = FALSE, etaSqP = FALSE, omegaSq = FALSE, plotError = "ci",
  ciWidth = 95, ss = "3")
}
\arguments{
\item{data}{the data as a data frame}

\item{dependent}{a string naming the dependent variable from \code{data}, 
variable must be numeric}

\item{fixedFactors}{a vector of strings naming the fixed factors from 
\code{data}}

\item{modelTerms}{a list of character vectors describing the terms to go 
into the model}

\item{contrasts}{contrasts}

\item{descPlotsHAxis}{a string naming the variable placed on the horizontal 
axis of the plot}

\item{descPlotsSepLines}{a string naming the variable represented as 
separate lines on the plot}

\item{descPlotsSepPlots}{a string naming the variable to separate over to 
form multiple plots}

\item{postHoc}{a list of terms to perform post-hoc tests on}

\item{corrNone}{\code{TRUE} or \code{FALSE} (default), provide uncorrected 
p-values in post-hoc tests}

\item{corrTukey}{\code{TRUE} (default) or \code{FALSE}, perform Tukey 
correction in post-hoc tests}

\item{corrScheffe}{\code{TRUE} or \code{FALSE} (default), perform Scheffe 
correction in post-hoc tests}

\item{corrBonf}{\code{TRUE} or \code{FALSE} (default), perform Bonferroni 
correction in post-hoc tests}

\item{corrHolm}{\code{TRUE} or \code{FALSE} (default), perform Holm 
correction in post-hoc tests}

\item{descStats}{\code{TRUE} or \code{FALSE} (default), provide descriptive 
statistics}

\item{homo}{\code{TRUE} or \code{FALSE} (default), perform homogeneity 
tests}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of 
residuals}

\item{etaSq}{\code{TRUE} or \code{FALSE} (default), provide eta² (effect 
size)}

\item{etaSqP}{\code{TRUE} or \code{FALSE} (default), provide partial eta² 
(effect size)}

\item{omegaSq}{\code{TRUE} or \code{FALSE} (default), provide omega² 
(effect size)}

\item{plotError}{\code{'ci'} or \code{'se'}, use confidence intervals or 
standard errors on the plot}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the 
confidence interval width}

\item{ss}{\code{'1'}, \code{'2'} or \code{'3'} (default), the sum of 
squares to use}
}
\description{
Analysis of Variance
}

