% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.h.R
\name{descriptives}
\alias{descriptives}
\title{Descriptives}
\usage{
descriptives(data, vars, mean = TRUE, median = TRUE, mode = FALSE,
  sum = FALSE, sd = FALSE, variance = FALSE, range = FALSE,
  min = TRUE, max = TRUE, se = FALSE, skew = FALSE, kurt = FALSE,
  freq = FALSE, plots = FALSE, plotW = 480, plotH = 320,
  quart = FALSE, pcEqGr = FALSE, pcNEqGr = 4)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables of interest in 
\code{data}}

\item{mean}{\code{TRUE} (default) or \code{FALSE}, provide the mean}

\item{median}{\code{TRUE} (default) or \code{FALSE}, provide the median}

\item{mode}{\code{TRUE} or \code{FALSE} (default), provide the mode}

\item{sum}{\code{TRUE} or \code{FALSE} (default), provide the sum}

\item{sd}{\code{TRUE} or \code{FALSE} (default), provide the standard 
deviation}

\item{variance}{\code{TRUE} or \code{FALSE} (default), provide the variance}

\item{range}{\code{TRUE} or \code{FALSE} (default), provide the range}

\item{min}{\code{TRUE} or \code{FALSE} (default), provide the minimum}

\item{max}{\code{TRUE} or \code{FALSE} (default), provide the maximum}

\item{se}{\code{TRUE} or \code{FALSE} (default), provide the standard error}

\item{skew}{\code{TRUE} or \code{FALSE} (default), provide the skewness}

\item{kurt}{\code{TRUE} or \code{FALSE} (default), provide the kurtosis}

\item{freq}{\code{TRUE} or \code{FALSE} (default), provide frequency tables 
(nominal, ordinal variables only)}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide frequency 
tables (nominal, ordinal variables only)}

\item{plotW}{an integer (default: 480) specifying the width of the plots}

\item{plotH}{an integer (default: 320) specifying the height of the plots}

\item{quart}{\code{TRUE} or \code{FALSE} (default), provide quartiles}

\item{pcEqGr}{\code{TRUE} or \code{FALSE} (default), provide quantiles}

\item{pcNEqGr}{an integer (default: 4) specifying the number of equal 
groups}
}
\description{
Provides a range of descriptive statistics
}
\examples{
\dontrun{
data('mtcars')
dat <- mtcars

# frequency tables can be provided for factors
dat$gear <- as.factor(dat$gear)

descriptives(dat, vars = c('mpg', 'cyl', 'disp', 'gear'), freq = TRUE)

#
#  Descriptives
#
#  Descriptives
#  -------------------------------------------
#               mpg     cyl     disp    gear
#  -------------------------------------------
#    N            32      32      32      32
#    Missing       0       0       0       0
#    Mean       20.1    6.19     231
#    Median     19.2    6.00     196
#    Minimum    10.4    4.00    71.1
#    Maximum    33.9    8.00     472
#  -------------------------------------------
#
#
#  Frequencies
#
#  Frequencies of gear
#  -------------------------------------------
#    Level    Counts    \%       Cumulative \%
#  -------------------------------------------
#    3            15    46.9            46.9
#    4            12    37.5            84.4
#    5             5    15.6           100.0
#  -------------------------------------------
#
}
}
