
# This file is automatically generated, you probably don't want to edit this

reliabilityOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "reliabilityOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            alphaScale = TRUE,
            omegaScale = FALSE,
            meanScale = FALSE,
            sdScale = FALSE,
            corPlot = FALSE,
            alphaItems = FALSE,
            omegaItems = FALSE,
            meanItems = FALSE,
            sdItems = FALSE,
            itemRestCor = FALSE,
            revItems = NULL, ...) {

            super$initialize(
                package='jmv',
                name='reliability',
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "ordinal",
                    "continuous"),
                permitted=list(
                    "numeric"),
                rejectInf=FALSE,
                takeFromDataIfMissing=TRUE)
            private$..alphaScale <- jmvcore::OptionBool$new(
                "alphaScale",
                alphaScale,
                default=TRUE)
            private$..omegaScale <- jmvcore::OptionBool$new(
                "omegaScale",
                omegaScale,
                default=FALSE)
            private$..meanScale <- jmvcore::OptionBool$new(
                "meanScale",
                meanScale,
                default=FALSE)
            private$..sdScale <- jmvcore::OptionBool$new(
                "sdScale",
                sdScale,
                default=FALSE)
            private$..corPlot <- jmvcore::OptionBool$new(
                "corPlot",
                corPlot,
                default=FALSE)
            private$..alphaItems <- jmvcore::OptionBool$new(
                "alphaItems",
                alphaItems,
                default=FALSE)
            private$..omegaItems <- jmvcore::OptionBool$new(
                "omegaItems",
                omegaItems,
                default=FALSE)
            private$..meanItems <- jmvcore::OptionBool$new(
                "meanItems",
                meanItems,
                default=FALSE)
            private$..sdItems <- jmvcore::OptionBool$new(
                "sdItems",
                sdItems,
                default=FALSE)
            private$..itemRestCor <- jmvcore::OptionBool$new(
                "itemRestCor",
                itemRestCor,
                default=FALSE)
            private$..revItems <- jmvcore::OptionVariables$new(
                "revItems",
                revItems,
                default=NULL)

            self$.addOption(private$..vars)
            self$.addOption(private$..alphaScale)
            self$.addOption(private$..omegaScale)
            self$.addOption(private$..meanScale)
            self$.addOption(private$..sdScale)
            self$.addOption(private$..corPlot)
            self$.addOption(private$..alphaItems)
            self$.addOption(private$..omegaItems)
            self$.addOption(private$..meanItems)
            self$.addOption(private$..sdItems)
            self$.addOption(private$..itemRestCor)
            self$.addOption(private$..revItems)
        }),
    active = list(
        vars = function() private$..vars$value,
        alphaScale = function() private$..alphaScale$value,
        omegaScale = function() private$..omegaScale$value,
        meanScale = function() private$..meanScale$value,
        sdScale = function() private$..sdScale$value,
        corPlot = function() private$..corPlot$value,
        alphaItems = function() private$..alphaItems$value,
        omegaItems = function() private$..omegaItems$value,
        meanItems = function() private$..meanItems$value,
        sdItems = function() private$..sdItems$value,
        itemRestCor = function() private$..itemRestCor$value,
        revItems = function() private$..revItems$value),
    private = list(
        ..vars = NA,
        ..alphaScale = NA,
        ..omegaScale = NA,
        ..meanScale = NA,
        ..sdScale = NA,
        ..corPlot = NA,
        ..alphaItems = NA,
        ..omegaItems = NA,
        ..meanItems = NA,
        ..sdItems = NA,
        ..itemRestCor = NA,
        ..revItems = NA)
)

reliabilityResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        scale = function() private$.items[["scale"]],
        items = function() private$.items[["items"]],
        corPlot = function() private$.items[["corPlot"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Reliability Analysis")
            self$add(jmvcore::Table$new(
                options=options,
                name="scale",
                title="Scale Reliability Statistics",
                rows=1,
                refs="psych",
                clearWith=list(
                    "vars",
                    "revItems"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `type`="text", 
                        `content`="scale"),
                    list(
                        `name`="mean", 
                        `title`="mean", 
                        `visible`="(meanScale)"),
                    list(
                        `name`="sd", 
                        `title`="sd", 
                        `visible`="(sdScale)"),
                    list(
                        `name`="alpha", 
                        `title`="Cronbach's \u03B1", 
                        `visible`="(alphaScale)"),
                    list(
                        `name`="omega", 
                        `title`="McDonald's \u03C9", 
                        `visible`="(omegaScale)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="items",
                title="Item Reliability Statistics",
                visible="(meanItems || sdItems || itemRestCor || alphaItems || omegaItems)",
                rows="(vars)",
                clearWith=list(
                    "vars",
                    "revItems"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="mean", 
                        `title`="mean", 
                        `visible`="(meanItems)"),
                    list(
                        `name`="sd", 
                        `title`="sd", 
                        `visible`="(sdItems)"),
                    list(
                        `name`="itemRestCor", 
                        `title`="item-rest correlation", 
                        `visible`="(itemRestCor)"),
                    list(
                        `name`="alpha", 
                        `title`="Cronbach's \u03B1", 
                        `superTitle`="if item dropped", 
                        `visible`="(alphaItems)"),
                    list(
                        `name`="omega", 
                        `title`="McDonald's \u03C9", 
                        `superTitle`="if item dropped", 
                        `visible`="(omegaItems)"))))
            self$add(jmvcore::Image$new(
                options=options,
                name="corPlot",
                title="Correlation Heatmap",
                visible="(corPlot)",
                width=400,
                height=400,
                renderFun=".corPlot",
                clearWith=list(
                    "vars",
                    "revItems")))}))

reliabilityBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "reliabilityBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'reliability',
                version = c(1,0,0),
                options = options,
                results = reliabilityResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE,
                requiresMissings = FALSE)
        }))

#' Reliability Analysis
#'
#' Reliability Analysis
#'
#' @examples
#' data('iris')
#'
#' reliability(iris, vars = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'),
#'             omegaScale = TRUE)
#'
#' #
#' #  RELIABILITY ANALYSIS
#' #
#' #  Scale Reliability Statistics
#' #  -----------------------------------------
#' #             Cronbach's alpha    McDonald's omega
#' #  -----------------------------------------
#' #    scale           0.708           0.848
#' #  -----------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in
#'   \code{data}
#' @param alphaScale \code{TRUE} (default) or \code{FALSE}, provide Cronbach's
#'   alpha
#' @param omegaScale \code{TRUE} or \code{FALSE} (default), provide McDonald's
#'   omega
#' @param meanScale \code{TRUE} or \code{FALSE} (default), provide the mean
#' @param sdScale \code{TRUE} or \code{FALSE} (default), provide the standard
#'   deviation
#' @param corPlot \code{TRUE} or \code{FALSE} (default), provide a correlation
#'   plot
#' @param alphaItems \code{TRUE} or \code{FALSE} (default), provide what the
#'   Cronbach's alpha would be if the item was dropped
#' @param omegaItems \code{TRUE} or \code{FALSE} (default), provide what the
#'   McDonald's omega would be if the item was dropped
#' @param meanItems \code{TRUE} or \code{FALSE} (default), provide item means
#' @param sdItems \code{TRUE} or \code{FALSE} (default), provide item standard
#'   deviations
#' @param itemRestCor \code{TRUE} or \code{FALSE} (default), provide item-rest
#'   correlations
#' @param revItems a vector containing strings naming the varibales that are
#'   reverse scaled
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$scale} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$items} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$corPlot} \tab \tab \tab \tab \tab an image \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$scale$asDF}
#'
#' \code{as.data.frame(results$scale)}
#'
#' @export
reliability <- function(
    data,
    vars,
    alphaScale = TRUE,
    omegaScale = FALSE,
    meanScale = FALSE,
    sdScale = FALSE,
    corPlot = FALSE,
    alphaItems = FALSE,
    omegaItems = FALSE,
    meanItems = FALSE,
    sdItems = FALSE,
    itemRestCor = FALSE,
    revItems = NULL) {

    if ( ! requireNamespace('jmvcore'))
        stop('reliability requires jmvcore to be installed (restart may be required)')

    if ( ! missing(vars)) vars <- jmvcore::resolveQuo(jmvcore::enquo(vars))
    if ( ! missing(revItems)) revItems <- jmvcore::resolveQuo(jmvcore::enquo(revItems))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(vars), vars, NULL),
            `if`( ! missing(revItems), revItems, NULL))

    vars <- `if`( ! missing(vars), vars, colnames(data))

    options <- reliabilityOptions$new(
        vars = vars,
        alphaScale = alphaScale,
        omegaScale = omegaScale,
        meanScale = meanScale,
        sdScale = sdScale,
        corPlot = corPlot,
        alphaItems = alphaItems,
        omegaItems = omegaItems,
        meanItems = meanItems,
        sdItems = sdItems,
        itemRestCor = itemRestCor,
        revItems = revItems)

    analysis <- reliabilityClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
