% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logregmulti.h.R
\name{logRegMulti}
\alias{logRegMulti}
\title{Multinomial Logistic Regression}
\usage{
logRegMulti(
  data,
  dep,
  covs = NULL,
  factors = NULL,
  blocks = list(list()),
  refLevels = NULL,
  modelTest = FALSE,
  dev = TRUE,
  aic = TRUE,
  bic = FALSE,
  pseudoR2 = list("r2mf"),
  omni = FALSE,
  ci = FALSE,
  ciWidth = 95,
  OR = FALSE,
  ciOR = FALSE,
  ciWidthOR = 95,
  emMeans = list(list()),
  ciEmm = TRUE,
  ciWidthEmm = 95,
  emmPlots = TRUE,
  emmTables = FALSE,
  emmWeights = TRUE
)
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{a string naming the dependent variable from \code{data},
variable must be a factor}

\item{covs}{a vector of strings naming the covariates from \code{data}}

\item{factors}{a vector of strings naming the fixed factors from
\code{data}}

\item{blocks}{a list containing vectors of strings that name the predictors
that are added to the model. The elements are added to the model according
to their order in the list}

\item{refLevels}{a list of lists specifying reference levels of the
dependent variable and all the factors}

\item{modelTest}{\code{TRUE} or \code{FALSE} (default), provide the model
comparison between the models and the NULL model}

\item{dev}{\code{TRUE} (default) or \code{FALSE}, provide the deviance (or
-2LogLikelihood) for the models}

\item{aic}{\code{TRUE} (default) or \code{FALSE}, provide Aikaike's
Information Criterion (AIC) for the models}

\item{bic}{\code{TRUE} or \code{FALSE} (default), provide Bayesian
Information Criterion (BIC) for the models}

\item{pseudoR2}{one or more of \code{'r2mf'}, \code{'r2cs'}, or
\code{'r2n'}; use McFadden's, Cox & Snell, and Nagelkerke pseudo-R²,
respectively}

\item{omni}{\code{TRUE} or \code{FALSE} (default), provide the omnibus
likelihood ratio tests for the predictors}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide a confidence
interval for the model coefficient estimates}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width}

\item{OR}{\code{TRUE} or \code{FALSE} (default), provide the exponential of
the log-odds ratio estimate, or the odds ratio estimate}

\item{ciOR}{\code{TRUE} or \code{FALSE} (default), provide a confidence
interval for the model coefficient odds ratio estimates}

\item{ciWidthOR}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width}

\item{emMeans}{a list of lists specifying the variables for which the
estimated marginal means need to be calculate. Supports up to three
variables per term.}

\item{ciEmm}{\code{TRUE} (default) or \code{FALSE}, provide a confidence
interval for the estimated marginal means}

\item{ciWidthEmm}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width for the estimated marginal means}

\item{emmPlots}{\code{TRUE} (default) or \code{FALSE}, provide estimated
marginal means plots}

\item{emmTables}{\code{TRUE} or \code{FALSE} (default), provide estimated
marginal means tables}

\item{emmWeights}{\code{TRUE} (default) or \code{FALSE}, weigh each cell
equally or weigh them according to the cell frequency}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$modelFit} \tab \tab \tab \tab \tab a table \cr
  \code{results$modelComp} \tab \tab \tab \tab \tab a table \cr
  \code{results$models} \tab \tab \tab \tab \tab an array of model specific results \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$modelFit$asDF}

\code{as.data.frame(results$modelFit)}
}
\description{
Multinomial Logistic Regression
}
\examples{
data('birthwt', package='MASS')

dat <- data.frame(
            race = factor(birthwt$race),
            age = birthwt$age,
            low = factor(birthwt$low))

logRegMulti(data = dat, dep = race,
            covs = age, factors = low,
            blocks = list(list("age", "low")),
            refLevels = list(
                list(var="race", ref="1"),
                list(var="low", ref="0")))

#
#  MULTINOMIAL LOGISTIC REGRESSION
#
#  Model Fit Measures
#  --------------------------------------
#    Model    Deviance    AIC    R²-McF
#  --------------------------------------
#        1         360    372    0.0333
#  --------------------------------------
#
#
#  MODEL SPECIFIC RESULTS
#
#  MODEL 1
#
#  Model Coefficients
#  ---------------------------------------------------------------
#    race     Predictor    Estimate    SE        Z         p
#  ---------------------------------------------------------------
#    2 - 1    Intercept      0.8155    1.1186     0.729    0.466
#             age           -0.1038    0.0487    -2.131    0.033
#             low:
#             1 – 0          0.7527    0.4700     1.601    0.109
#    3 - 1    Intercept      1.0123    0.7798     1.298    0.194
#             age           -0.0663    0.0324    -2.047    0.041
#             low:
#             1 – 0          0.5677    0.3522     1.612    0.107
#  ---------------------------------------------------------------
#
#

}
