% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conttables.h.R
\name{contTables}
\alias{contTables}
\title{Contingency Tables}
\usage{
contTables(data, rows, cols, counts = NULL, layers = NULL,
  chiSq = TRUE, chiSqCorr = FALSE, zProp = FALSE, likeRat = FALSE,
  fisher = FALSE, contCoef = FALSE, phiCra = FALSE,
  diffProp = FALSE, logOdds = FALSE, odds = FALSE, relRisk = FALSE,
  ci = TRUE, ciWidth = 95, compare = "rows",
  hypothesis = "different", gamma = FALSE, taub = FALSE,
  mh = FALSE, obs = TRUE, exp = FALSE, pcRow = FALSE,
  pcCol = FALSE, pcTot = FALSE, barplot = FALSE, yaxis = "ycounts",
  yaxisPc = "total_pc", xaxis = "xrows", bartype = "dodge", formula)
}
\arguments{
\item{data}{the data as a data frame}

\item{rows}{the variable to use as the rows in the contingency table (not
necessary when providing a formula, see the examples)}

\item{cols}{the variable to use as the columns in the contingency table
(not necessary when providing a formula, see the examples)}

\item{counts}{the variable to use as the counts in the contingency table
(not necessary when providing a formula, see the examples)}

\item{layers}{the variables to use to split the contingency table (not
necessary when providing a formula, see the examples)}

\item{chiSq}{\code{TRUE} (default) or \code{FALSE}, provide X²}

\item{chiSqCorr}{\code{TRUE} or \code{FALSE} (default), provide X² with
continuity correction}

\item{zProp}{\code{TRUE} or \code{FALSE} (default), provide a z test for
differences between two proportions}

\item{likeRat}{\code{TRUE} or \code{FALSE} (default), provide the
likelihood ratio}

\item{fisher}{\code{TRUE} or \code{FALSE} (default), provide Fisher's exact
test}

\item{contCoef}{\code{TRUE} or \code{FALSE} (default), provide the
contingency coefficient}

\item{phiCra}{\code{TRUE} or \code{FALSE} (default), provide Phi and
Cramer's V}

\item{diffProp}{\code{TRUE} or \code{FALSE} (default), provide the
differences in proportions (only available for 2x2 tables)}

\item{logOdds}{\code{TRUE} or \code{FALSE} (default), provide the log odds
ratio (only available for 2x2 tables)}

\item{odds}{\code{TRUE} or \code{FALSE} (default), provide the odds ratio
(only available for 2x2 tables)}

\item{relRisk}{\code{TRUE} or \code{FALSE} (default), provide the relative
risk (only available for 2x2 tables)}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide confidence
intervals for the comparative measures}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), width of the
confidence intervals to provide}

\item{compare}{\code{columns} or \code{rows} (default), compare
columns/rows in difference of proportions or relative risks (2x2 tables)}

\item{hypothesis}{\code{'different'} (default), \code{'oneGreater'} or
\code{'twoGreater'}, the alternative hypothesis; group 1 different to group
2, group 1 greater than group 2, and group 2 greater than group 1
respectively}

\item{gamma}{\code{TRUE} or \code{FALSE} (default), provide gamma}

\item{taub}{\code{TRUE} or \code{FALSE} (default), provide Kendall's tau-b}

\item{mh}{\code{TRUE} or \code{FALSE} (default), provide Mantel-Haenszel
test for trend}

\item{obs}{\code{TRUE} or \code{FALSE} (default), provide the observed
counts}

\item{exp}{\code{TRUE} or \code{FALSE} (default), provide the expected
counts}

\item{pcRow}{\code{TRUE} or \code{FALSE} (default), provide row percentages}

\item{pcCol}{\code{TRUE} or \code{FALSE} (default), provide column
percentages}

\item{pcTot}{\code{TRUE} or \code{FALSE} (default), provide total
percentages}

\item{barplot}{\code{TRUE} or \code{FALSE} (default), show barplots}

\item{yaxis}{ycounts (default) or ypc. Use respectively \code{counts} or
\code{percentages} for the bar plot y-axis}

\item{yaxisPc}{total_pc (default), column_pc, or row_pc. Use respectively
percentages \code{of total}, \code{within columns}, or \code{within rows}
for the bar plot y-axis.}

\item{xaxis}{rows (default), or columns in bar plot X axis}

\item{bartype}{stack or side by side (default), barplot type}

\item{formula}{(optional) the formula to use, see the examples}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$freqs} \tab \tab \tab \tab \tab a table of proportions \cr
  \code{results$chiSq} \tab \tab \tab \tab \tab a table of X² test results \cr
  \code{results$odds} \tab \tab \tab \tab \tab a table of comparative measures \cr
  \code{results$nom} \tab \tab \tab \tab \tab a table of the 'nominal' test results \cr
  \code{results$gamma} \tab \tab \tab \tab \tab a table of the gamma test results \cr
  \code{results$taub} \tab \tab \tab \tab \tab a table of the Kendall's tau-b test results \cr
  \code{results$mh} \tab \tab \tab \tab \tab a table of the Mantel-Haenszel test for trend \cr
  \code{results$barplot} \tab \tab \tab \tab \tab an image \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$freqs$asDF}

\code{as.data.frame(results$freqs)}
}
\description{
The X² test of association (not to be confused with the X² goodness of fit) 
is used to test whether two categorical variables are independent or 
associated. If the p-value is low, it suggests the variables are not 
independent, and that there is a relationship between the two variables.
}
\examples{
data('HairEyeColor')
dat <- as.data.frame(HairEyeColor)

contTables(formula = Freq ~ Hair:Eye, dat)

#
#  CONTINGENCY TABLES
#
#  Contingency Tables
#  -----------------------------------------------------
#    Hair     Brown    Blue    Hazel    Green    Total
#  -----------------------------------------------------
#    Black       68      20       15        5      108
#    Brown      119      84       54       29      286
#    Red         26      17       14       14       71
#    Blond        7      94       10       16      127
#    Total      220     215       93       64      592
#  -----------------------------------------------------
#
#
#  X² Tests
#  -------------------------------
#          Value    df    p
#  -------------------------------
#    X²      138     9    < .001
#    N       592
#  -------------------------------
#

# Alternatively, omit the left of the formula (`Freq`) if each row
# represents a single observation:

contTables(formula = ~ Hair:Eye, dat)

}
