% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheesepop.R
\name{cheesepop}
\alias{cheesepop}
\title{cheesepop: Population disaggregation by two-level demographic groups (eg., age and sex), without covariates}
\usage{
cheesepop(df, output_dir, verbose = TRUE)
}
\arguments{
\item{df}{A data frame object containing sample data (often partially observed) on age and sex groups population data
as well as the estimated overall total counts per administrative unit.}

\item{output_dir}{This is the directory with the name of the output folder where the
disaggregated population proportions and population totals are
automatically saved.}

\item{verbose}{Logical. If TRUE (default), progress messages are displayed during model execution.
Set to FALSE to suppress informational messages.}
}
\value{
A list of data frame objects of the output files including the disaggregated population proportions and population totals
along with the corresponding measures of uncertainties (lower and upper bounds of 95-percent credible intervals) for each demographic characteristic.
In addition, a file containing the model performance/model fit evaluation metrics is also produced.
}
\description{
Similar to the 'cheesecake' function, 'cheesepop' disaggregates small area population estimates by age, sex, and
other socio-demographic and socio-economic characteristics (e.g., ethnicity, religion, educational level, immigration status, etc), at the administrative unit level.
However, unlike the 'cheesecake' function which uses geospatial covariates to predict missing data values, the
'cheesepop' does not require the use of geospatial covariates.

It uses Bayesian statistical models to predict population proportions and population totals for the demographic groups of interest.
Primarily designed to help users in filling population data gaps across demographic groups due to outdated or incomplete census data.
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
 data(toydata)
 result <- cheesepop(df = toydata$admin, output_dir = tempdir())
}
}
}
