% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_print_journal.R
\name{format_means_df}
\alias{format_means_df}
\title{Format multiple data.frame 'mean_*' columns for presentation (by data type).}
\usage{
format_means_df(df, d_type, central_var = "mean", style_name = "nature")
}
\arguments{
\item{df}{[data.table] input data.table with one or more 'mean_' columns}

\item{d_type}{[chr c('prop', 'pp', or 'count')] a single data type}

\item{central_var}{[chr: default 'mean'] prefix of mean variable names to
format.  Implemented as e.g. "^mean[_]*" to capture 'mean', 'mean_1990',
'mean_2000', etc.}

\item{style_name}{[chr: default 'nature'] style name - controls rounding and
formatting.}
}
\value{
[data.table] copy of input data.table with formatted mean column(s)
}
\description{
Format one or more 'mean_' columns by magnitude, data_type, and style.
}
\details{
BEWARE: Does not have sophisticated count-type data handling like
`format_journal_clu()`.  This is a simple formatter for multiple mean columns.
Use with caution.
}
\examples{
df <- data.frame(
  location_id = c(1, 2, 3)
  , mean_1990 = c(100, 1e6, 1e9)
  , mean_2000 = c(200, 2e6, 2e-1)
 )
format_means_df(df, d_type = "count")
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_clu}()},
\code{\link{format_journal_df}()},
\code{\link{format_lancet_clu}()},
\code{\link{format_lancet_df}()},
\code{\link{format_nature_clu}()},
\code{\link{format_nature_df}()},
\code{\link{fround_clu_triplet}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
