% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_id.R
\name{is_id}
\alias{is_id}
\title{Check if dt is uniquely identified by \code{by} variable}
\usage{
is_id(dt, by, verbose = getOption("joyn.verbose"), return_report = FALSE)
}
\arguments{
\item{dt}{either right of left table}

\item{by}{variable to merge by}

\item{verbose}{logical: if TRUE messages will be displayed}

\item{return_report}{logical: if TRUE, returns data with summary of duplicates.
If FALSE, returns logical value depending on whether \code{dt} is uniquely identified
by \code{by}}
}
\value{
logical or data.frame, depending on the value of argument \code{return_report}
}
\description{
report if dt is uniquely identified by \code{by} var or, if report = TRUE, the duplicates in \code{by} variable
}
\examples{
library(data.table)

# example with data frame not uniquely identified by `by` var

y <- data.table(id = c("c","b", "c", "a"),
                 y  = c(11L, 15L, 18L, 20L))
is_id(y, by = "id")
is_id(y, by = "id", return_report = TRUE)

# example with data frame uniquely identified by `by` var

y1 <- data.table(id = c("1","3", "2", "9"),
                 y  = c(11L, 15L, 18L, 20L))
is_id(y1, by = "id")
}
