% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{getSessionVariable}
\alias{getSessionVariable}
\title{Get a variable from a client session environment}
\usage{
getSessionVariable(varName, sessionId = NULL)
}
\arguments{
\item{varName}{Name of the variable to search for. Must be a character.}

\item{sessionId}{ID of the session. If there is only one active session, this argument becomes optional.}
}
\value{
Requested variable
}
\description{
This function returns a variable, how it is seen from a session, e.g. for all the received function calls and
commands. It searches for the variable in the session environment first, and then, if variable is not found, checks enclosing 
frames of the environment, starting from the outer environment of the app (see \code{\link{setEnvironment}}). If the variable
doesn't exist, throws an error.
}
\details{
This function
is a wrapper around method \code{sessionVariables} of the class \code{\link{Session}}.
}
\examples{
\donttest{f <- function(x) {x * 3}
openPage(allowedFunctions = "f", allowedVariables = "k")
getPage()$openPage(FALSE)
id1 <- getSessionIds()[1]
id2 <- getSessionIds()[2]
sendCommand("jrc.callFunction('f', [10], 'k')", sessionId = id1, wait = 3)
sendCommand("jrc.callFunction('f', [20], 'k')", sessionId = id2, wait = 3)
k1 <- getSessionVariable("k", id1)
k2 <- getSessionVariable("k", id2)

closePage()}

}
\seealso{
\code{\link{setSessionVariables}}
}
