% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jcc.plot.R
\name{jcc.plot}
\alias{jcc.plot}
\title{Plot the category curves for a judge.}
\usage{
jcc.plot(
  jrt.object,
  judge = "all",
  labelled = T,
  greyscale = F,
  vertical.labels = F,
  title = "auto",
  column.names = "auto",
  manual.facet.names = "auto",
  manual.line.names = "auto",
  overlay.reliability = F,
  color.palette = "D3",
  category.name.for.legend = "",
  name.for.reliability = "auto",
  theta.span = 3.5,
  line.width = 0.8,
  line.opacity = 1,
  key.width = 3,
  legend.position = "right",
  legend.columns = "",
  theme = "bw",
  text.size = 10,
  title.size = text.size + 4,
  font.family = "sans",
  remove.gridlines = T,
  facet.rows = NULL,
  facet.cols = NULL,
  facet.title.position = "top",
  precision = 20,
  debug = F,
  mirt.object.input = F,
  item = NULL
)
}
\arguments{
\item{jrt.object}{A object of the \code{jrt} class (created by the function \code{jrt}).}

\item{judge}{A numerical to indicate which judge(s) to plot. Default is \code{all} which plots all category curves of all judges. Alternatively, a single integer may be used to plot the JCC for one judge, or a vector of integers to plot multiple judges in a faceted plot. Note that, if a (Generalized) Rating Scale Model was used, then judges may have been removed for the model to be fitted.}

\item{labelled}{A logical to indicate whether the curves should be labelled with boxed labels (\code{TRUE}, default) or whether a legend should be used instead (\code{FALSE}). This uses the package \code{directlabels}. Note that the rendering is slower (and may take more time to show in GUI) when the plot is labelled.}

\item{greyscale}{A logical to indicate whether to plot in greyscale (\code{TRUE}, default) as opposed to color (\code{FALSE}).}

\item{vertical.labels}{A logical to indicate whether the labels should be vertically oriented (\code{TRUE}), as opposed to oriented inthe angle of the trace curve (\code{FALSE}, the default).}

\item{title}{A character title for the plot. By default it is created automatically based on the judge number.}

\item{column.names}{A character to indicate what a column corresponds to (Defaults to \code{"auto"}, which uses what was set in the estimation function \code{jrt}, whose default is \code{"judge"}, but you may use \code{"Rater"}, \code{"Expert"}, \code{"Item"}, etc.). This is used to create automatic titles.}

\item{manual.facet.names}{A vector to indicate the names to give to the different facets. Defaults to \code{"auto"}, which will automatically name them. If not using \code{"auto"}, the vector length should be equal to the total number of items/judges (not the total in the plot but the total in the dataset).}

\item{manual.line.names}{A vector to indicate the individual names to give to the different response categories (or different category curves). Defaults to \code{"auto"}, which names categories from 1 to the number of categories. If not using \code{"auto"}, the vector supplied should be of the same length as the number of response categories (use the \code{name.for.reliability} argument to change it for reliability).}

\item{overlay.reliability}{A logical to indicate whether to overlay the reliability function of the item (default is \code{FALSE}). If overlayed (\code{TRUE}), the reliability function will be contrast with the category curves by being in color if the category curves are in blackandwhite, and in black dashed if the category curves are in color.}

\item{color.palette}{A character value to indicate the colour palette to use. Defaults to \code{"D3"} from "ggsci". Use \code{""} for the default of \code{ggplot2}. The palettes are supplied as arguments to \code{ggplot2}. See here for a list of palettes. In addition, most palettes from the package \code{ggsci} are available (e.g., \code{"npg"}, \code{"aas"}, \code{"nejm"}, \code{"lancet"}, \code{"jama"}, \code{"d3"}). Use \code{vignette("ggsci")} for details. Make sure there are enough colors in the palette. Alternatively, you can pass a vector of colors.}

\item{category.name.for.legend}{A character to indicate how to call categories in the legend. Default to \code{"Category"} but for example you may try \code{"Cat."} or even \code{""} to save space.}

\item{name.for.reliability}{A character to indicate a preferred name for reliability in the legend or labels. Defaults to \code{"auto"}, which adapts to whether labels are used.}

\item{theta.span}{A numeric indicating the maximum \eqn{\theta}.}

\item{line.width}{A numeric indicating the width of the trace lines (default is \code{2.5}).}

\item{line.opacity}{A numeric vector to indicate opacities for the different category lines. Defaults to \code{1}. Must be of length equal to the number of categories + 1 (for the reliability line, even if not plotted). For example if there are 5 response categories this vector should be of length 6.}

\item{key.width}{A numeric to indicate the width of the legend key (default is \code{3}).}

\item{legend.position}{A character string or vector of coordinates to position the legend key. Defaults to \code{"right"}. Other possibilities include notably \code{"bottom"}.}

\item{legend.columns}{A numeric to indicate after how many legend key elements to add a line break. Especially useful if using \code{legend.position = "bottom"} if you want line breaks between each key. Defaults to \code{""}, which automatically saves space based on the legend position (line breaks are used if the legend in positioned on the side of the graph).}

\item{theme}{A character value to indicate the background color theme used by \code{ggplot2}. Defaults to \code{"bw"}. Can be \code{"light"}, \code{"dark"}, \code{"minimal"}, \code{"classic"}, \code{"gray"}, \code{"bw"} or \code{"linedraw"}.}

\item{text.size}{A numeric value to control the size of the text on the plot.}

\item{title.size}{A numeric value to control the size of the plot title (defaults to \code{text.size+4}).}

\item{font.family}{A character value to control the font family used on the graph. Defaults to \code{"sans"}. Other possible values include \code{"serif"} or \code{"mono"}.}

\item{remove.gridlines}{A logical value to remove the gridlines (default is \code{TRUE}).}

\item{facet.rows}{A numeric to change the number of rows for faceted plots. Use this one or \code{facet.cols}, not both. Defaults to \code{NULL}, which uses \code{ggplot2}'s automatic layout.}

\item{facet.cols}{A numeric to change the number of columns for faceted plots. Use this one or \code{facet.row}, not both. Defaults to \code{NULL}, which uses \code{ggplot2}'s automatic layout.}

\item{facet.title.position}{A character string to indicate the position of the facet titles for faceted plts. Defaults to \code{"top"}, but can be \code{"bottom"}, \code{"left"}, or \code{"right"}.}

\item{precision}{A numeric to indicate the degree of precision used to plot the category curves. Higher values will increase the accuracy of the graph and make the curves look smoother, but the data generated to plot the graph will be bigger, which will slow down the function. Lower values will do the opposite. Values between \code{10} and \code{100} are recommended, \code{20} is the default and sufficient for most uses.}

\item{debug}{A logical to report debug messages (used in development).
Defaults to \code{FALSE}.}

\item{mirt.object.input}{A logical allowing to input directly an \code{mirt} object as a \code{jrt.object} argument, even though this should be detected automatically. See \code{mirt} package documentation, and note that this is a secondary use that may lead to inconsistent results at this point.}

\item{item}{For convenience, this argument, more standard to IRT packages, can be used instead of the \code{judge} argument.}
}
\value{
A plot of the category curves.
}
\description{
This function returns the Judge Category Curves (JCC) plot from a \code{jrt} object and the judge number. This is a wrapper function and adaptation of the \code{itemplot} function in the package \code{mirt} (Chalmers, 2012). It also uses the plotting functions of the packages \code{directlabels} and \code{ggplot2}.
}
\examples{


# Load dataset
data <- jrt::ratings

# Fit model
fit <- jrt(data, irt.model = "PCM")

# JCC of the first judge
jcc.plot(fit, 1)

# See vignette for more options

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29. \doi{10.18637/jss.v048.i06}

Myszkowski, N., & Storme, M. (2019). Judge Response Theory? A call to upgrade our psychometrical account of creativity judgments. \emph{Psychology of Aesthetics, Creativity and the Arts, 13}(2), 167-175. \doi{10.1037/aca0000225}

Myszkowski, N. (2021). Development of the R library “jrt”: Automated item response theory procedures for judgment data and their application with the consensual assessment techniques. \emph{Psychology of Aesthetics, Creativity and the Arts, 15}(3), 426-438. \doi{10.1037/aca0000287}
}
