% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve-irr.R
\name{irr.solve}
\alias{irr.solve}
\title{Solve for IRR (internal rate of return) or YTM (yield to maturity)}
\usage{
irr.solve(
  f,
  interval = NULL,
  r.guess = NULL,
  toler = 1e-06,
  convergence = 1e-08,
  max.iter = 100,
  method = c("default", "newton", "bisection")
)
}
\arguments{
\item{f}{The function whose zero is to be found. An R function
object that takes one numeric argument and returns a list of
two components (value and gradient). In the IRR applications,
these two components will be the NPV and its derivative}

\item{interval}{The interval c(lower, upper) within which to
search for the IRR}

\item{r.guess}{The starting value (guess) from which the solver
starts searching for the IRR}

\item{toler}{The argument \code{toler} to
\code{\link{newton.raphson.root}}.  The IRR is regarded as
correct if abs(NPV) is less than \code{toler}.  Otherwise the
\code{irr.solve} returns \code{NA}}

\item{convergence}{The argument \code{convergence} to
\code{\link{newton.raphson.root}}.}

\item{max.iter}{The maximum number of iterations of the
Newton-Raphson procedure}

\item{method}{The root finding method to be used. The
\code{default} is to try Newton-Raphson method
(\code{\link{newton.raphson.root}}) and if that fails to try
bisection (\code{\link{bisection.root}}). The other two
choices (\code{newton} and \code{bisection} force only one of
the methods to be tried.}
}
\value{
The function \code{irr.solve} returns \code{NA} if the IRR/YTM
    could not be found. Otherwise it returns the IRR/YTM. When
    \code{NA} is returned, a warning message is printed
}
\description{
This function computes the internal rate of return at which the
net present value equals zero. It requires as input a function
that computes the net present value of a series of cash flows for
a given interest rate as well as the derivative of the NPV with
respect to the interest rate (10,000 times this derivative is the
PVBP or DV01).  In this package, \code{irr.solve} is primarily
intended to be called by the \code{\link{irr}} and
\code{\link{bond.yield}} functions. It is made available for those
who want to find IRR of more complex instruments.
}
\details{
The function \code{irr.solve} is basically an interface to the
general root finder \code{\link{newton.raphson.root}}. However, if
\code{\link{newton.raphson.root}} fails, \code{irr.solve} makes an
attempt to find the root using \code{\link{uniroot}} from the R
stats package. \code{Uniroot} uses bisection and it requires the root to
be bracketed (the function must be of opposite sign at the two end
points - lower and upper).
}
\author{
Prof. Jayanth R. Varma \email{jrvarma@iima.ac.in}
}
